/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.rowset;

import crazydev.common.exception.CdRuntimeException;
import crazydev.xmla.model.annotation.XmlaAnDef;
import crazydev.xmla.model.annotation.XmlaAnDefs;
import crazydev.xmla.model.annotation.XmlaAnDiscoverType;
import crazydev.xmla.model.discover.IXmlaDBSchemaCatalogs;
import crazydev.xmla.model.discover.IXmlaDBSchemaTables;
import crazydev.xmla.model.discover.IXmlaDMSchemaMiningModels;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.discover.IXmlaDiscoverDataSources;
import crazydev.xmla.model.discover.IXmlaDiscoverInstance;
import crazydev.xmla.model.discover.IXmlaDiscoverKeyword;
import crazydev.xmla.model.discover.IXmlaDiscoverLiteral;
import crazydev.xmla.model.discover.IXmlaDiscoverProperties;
import crazydev.xmla.model.discover.IXmlaDiscoverSchemaRowSet;
import crazydev.xmla.model.discover.IXmlaDiscoverXmlMetaData;
import crazydev.xmla.model.discover.IXmlaMDSchemaAction;
import crazydev.xmla.model.discover.IXmlaMDSchemaCube;
import crazydev.xmla.model.discover.IXmlaMDSchemaDimension;
import crazydev.xmla.model.discover.IXmlaMDSchemaFunction;
import crazydev.xmla.model.discover.IXmlaMDSchemaHierarchy;
import crazydev.xmla.model.discover.IXmlaMDSchemaInputDataSource;
import crazydev.xmla.model.discover.IXmlaMDSchemaKPI;
import crazydev.xmla.model.discover.IXmlaMDSchemaLevel;
import crazydev.xmla.model.discover.IXmlaMDSchemaMeasure;
import crazydev.xmla.model.discover.IXmlaMDSchemaMeasureGroup;
import crazydev.xmla.model.discover.IXmlaMDSchemaMeasureGroupDimension;
import crazydev.xmla.model.discover.IXmlaMDSchemaMember;
import crazydev.xmla.model.discover.IXmlaMDSchemaProperty;
import crazydev.xmla.model.discover.IXmlaMDSchemaSet;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowSetColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSetColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSetMultipleColumn;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlaDiscoverRowSetFactory {
    private static final List<Class<? extends IXmlaDiscover>> types = new ArrayList<Class<? extends IXmlaDiscover>>();
    private static final Map<String, XmlaDiscoverRowSet> typesByGuid = new HashMap<String, XmlaDiscoverRowSet>();
    private static final Map<String, XmlaDiscoverRowSet> typesByNames = new HashMap<String, XmlaDiscoverRowSet>();

    private static void addAnnotatedClasses() {
        types.add(IXmlaMDSchemaFunction.class);
        types.add(IXmlaDBSchemaCatalogs.class);
        types.add(IXmlaDBSchemaTables.class);
        types.add(IXmlaDiscoverDataSources.class);
        types.add(IXmlaDiscoverProperties.class);
        types.add(IXmlaDiscoverSchemaRowSet.class);
        types.add(IXmlaDiscoverInstance.class);
        types.add(IXmlaDiscoverKeyword.class);
        types.add(IXmlaDiscoverLiteral.class);
        types.add(IXmlaMDSchemaAction.class);
        types.add(IXmlaMDSchemaCube.class);
        types.add(IXmlaMDSchemaDimension.class);
        types.add(IXmlaMDSchemaHierarchy.class);
        types.add(IXmlaMDSchemaInputDataSource.class);
        types.add(IXmlaMDSchemaKPI.class);
        types.add(IXmlaMDSchemaLevel.class);
        types.add(IXmlaMDSchemaMeasure.class);
        types.add(IXmlaMDSchemaMeasureGroup.class);
        types.add(IXmlaMDSchemaMeasureGroupDimension.class);
        types.add(IXmlaMDSchemaMember.class);
        types.add(IXmlaMDSchemaSet.class);
        types.add(IXmlaMDSchemaProperty.class);
        types.add(IXmlaDMSchemaMiningModels.class);
        types.add(IXmlaDiscoverXmlMetaData.class);
    }

    public static void compile(Class<? extends IXmlaDiscover> type) {
        String[] restrictionColumnNames;
        XmlaAnDiscoverType xmlaClazzAn = type.getAnnotation(XmlaAnDiscoverType.class);
        if (xmlaClazzAn == null) {
            throw new CdRuntimeException("[" + type.getName() + "] should be annotated with 'XmlaAnDiscoverType'");
        }
        Method[] methods = type.getMethods();
        XmlaDiscoverRowSet rowSet = new XmlaDiscoverRowSet(type, xmlaClazzAn);
        for (Method method : methods) {
            XmlaAnDef xmlaRowAn = method.getAnnotation(XmlaAnDef.class);
            if (xmlaRowAn != null) {
                XmlaDiscoverRowSetColumn rowColumn = new XmlaDiscoverRowSetColumn(xmlaRowAn, method);
                rowColumn.checkConsistency();
                rowSet.add(rowColumn);
                continue;
            }
            XmlaAnDefs xmlaRowAnDefs = method.getAnnotation(XmlaAnDefs.class);
            if (xmlaRowAnDefs == null) continue;
            XmlaDiscoverRowSetMultipleColumn rowColumn = new XmlaDiscoverRowSetMultipleColumn(rowSet, xmlaRowAnDefs, method);
            rowSet.add(rowColumn);
        }
        rowSet.onFinish();
        for (String restriction : xmlaClazzAn.restrictionOrder()) {
            IXmlaDiscoverRowSetColumn row = rowSet.getColumnByName(restriction);
            if (row == null) {
                throw new CdRuntimeException("restrictionOrder name [" + (String)restriction + "] not found in row list");
            }
            if (!row.isNotRestrictable()) continue;
            throw new CdRuntimeException("restrictionOrder name [" + (String)restriction + "] defined on a non restrictable row");
        }
        for (String columnName : restrictionColumnNames = xmlaClazzAn.sortedBy()) {
            rowSet.addSortedColumn(columnName);
        }
        String guid = xmlaClazzAn.guid();
        XmlaDiscoverRowSet old = typesByGuid.put(guid, rowSet);
        if (old != null) {
            throw new CdRuntimeException("Duplicated GUID [" + guid + "] [" + type.getSimpleName() + "] in [" + old.getType().getSimpleName() + "]");
        }
        typesByNames.put(xmlaClazzAn.name(), rowSet);
    }

    public static List<Class<? extends IXmlaDiscover>> getXmlSupportedClasses() {
        return Collections.unmodifiableList(types);
    }

    public static XmlaDiscoverRowSet getExisting(String name) {
        XmlaDiscoverRowSet value = typesByNames.get(name);
        if (value == null) {
            if (typesByNames.isEmpty()) {
                throw new CdRuntimeException("Missing XmlaDiscoverRowSetColumn, empty map, did you initialize this factory?");
            }
            throw new CdRuntimeException("Missing XmlaDiscoverRowSetColumn for [" + name + "]");
        }
        return value;
    }

    static {
        XmlaDiscoverRowSetFactory.addAnnotatedClasses();
        for (Class<? extends IXmlaDiscover> type : types) {
            XmlaDiscoverRowSetFactory.compile(type);
        }
    }
}

