/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.rowset;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.xmla.model.annotation.XmlaAnDef;
import crazydev.xmla.model.annotation.XmlaAnRestriction;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.types.XmlaHChapterElement;
import crazydev.xmla.model.types.XmlaTypeConverter;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowSetColumn;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class XmlaDiscoverRowSetColumn
implements IXmlaDiscoverRowSetColumn {
    private final XmlaAnDef column;
    private final Method javaMethod;

    protected XmlaDiscoverRowSetColumn(XmlaAnDef column, Method javaMethod) {
        this.column = column;
        this.javaMethod = javaMethod;
    }

    @Override
    public String getName() {
        return this.column.name();
    }

    public CdXmlaSchemaType getType() {
        return this.column.type();
    }

    @Override
    public int getPosition() {
        return this.column.pos();
    }

    @Override
    public void emitXmlSchema(XmlaSerializer serializer, IXmlaDiscover first) throws SAXException {
        if (this.column.restriction() == XmlaAnRestriction.RESTRICTION_ONLY) {
            return;
        }
        if (this.getType() == CdXmlaSchemaType.DBTYPE_HCHAPTER) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, "sql:field", "string", this.getName());
            attrs.addAttribute(null, null, "name", "string", this.getName());
            attrs.addAttribute(null, null, "minOccurs", "string", "0");
            attrs.addAttribute(null, null, "maxOccurs", "string", "unbounded");
            serializer.startElement(null, null, "xsd:element", (Attributes)attrs);
            serializer.startElement(null, null, "xsd:complexType", null);
            serializer.startElement(null, null, "xsd:sequence", null);
            for (String names : this.column.chapter()) {
                serializer.addXmlaSchemaElement("xsd:element", names, CdXmlaSchemaType.DBTYPE_WSTR, this.column.cardinality(), true);
            }
            serializer.endElement(null, null, "xsd:sequence");
            serializer.endElement(null, null, "xsd:complexType");
            serializer.endElement(null, null, "xsd:element");
        } else {
            serializer.addXmlaSchemaElement("xsd:element", this.getName(), this.getType(), this.column.cardinality(), true);
        }
    }

    @Override
    public void emitData(XmlaSerializer serializer, IXmlaDiscover xmlaDiscover) throws SAXException, IOException {
        Object value = this.getValue(xmlaDiscover);
        if (value != null) {
            if (this.getType() == CdXmlaSchemaType.DBTYPE_HCHAPTER && value instanceof List) {
                this.emitHChapterObject(serializer, value);
            } else if (this.getType() == CdXmlaSchemaType.DBTYPE_XML) {
                this.emitXmlObject(serializer, value);
            } else {
                this.emitSimpleObject(serializer, value);
            }
        }
    }

    private void emitXmlObject(XmlaSerializer serializer, Object value) throws SAXException, IOException {
        serializer.addRawXml((String)value);
    }

    private void emitHChapterObject(XmlaSerializer serializer, Object value) throws SAXException {
        List list = (List)value;
        for (Object o : list) {
            serializer.startElement(null, null, this.getName(), null);
            XmlaHChapterElement element = (XmlaHChapterElement)o;
            serializer.addElement("Name", element.getName());
            serializer.addElement("Type", element.getType());
            serializer.endElement(null, null, this.getName());
        }
    }

    private void emitSimpleObject(XmlaSerializer serializer, Object value) throws SAXException {
        String valueAsString = this.convertValueToString(value);
        serializer.startElement(null, null, this.getName(), null);
        if (valueAsString != null) {
            char[] xvalue = valueAsString.toCharArray();
            serializer.characters(xvalue, 0, xvalue.length);
        }
        serializer.endElement(null, null, this.getName());
    }

    @Nullable
    private String convertValueToString(@Nullable Object value) {
        String valueAsString = null;
        if (value != null) {
            valueAsString = XmlaTypeConverter.toString((CdXmlaSchemaType)this.column.type(), (Object)value);
        }
        return valueAsString;
    }

    @Override
    public void checkConsistency() {
        String[] chapter;
        Class<?> returnType = this.javaMethod.getReturnType();
        if (returnType == Void.TYPE) {
            throw new CdRuntimeException("method [" + this.javaMethod.toGenericString() + "] : cannot be void");
        }
        if (this.javaMethod.getGenericParameterTypes().length != 0) {
            throw new CdRuntimeException("method [" + this.javaMethod.toGenericString() + "] : cannot have parameters");
        }
        if (!this.column.type().isCompatible(returnType)) {
            throw new CdRuntimeException("method [" + this.javaMethod.toGenericString() + "] has an incompatibility between [" + String.valueOf(this.column.type()) + "] and [" + String.valueOf(returnType) + "] types ");
        }
        if (this.column.type() == CdXmlaSchemaType.DBTYPE_HCHAPTER && (chapter = this.column.chapter()).length == 0) {
            throw new CdRuntimeException("method [" + this.javaMethod.toGenericString() + "] defines a DBTYPE_HCHAPTER [" + String.valueOf(this.column.type()) + "] and not column is defined");
        }
    }

    @Nullable
    private Object getValue(IXmlaDiscover object) {
        try {
            if (object == null) {
                return null;
            }
            Object value = this.javaMethod.invoke((Object)object, new Object[0]);
            return value;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new CdRuntimeException((Throwable)ex, "Discover error for [" + object.getClass().getSimpleName() + "]");
        }
    }

    @Override
    public boolean isNotRestrictable() {
        return this.column.restriction() == XmlaAnRestriction.NOT_RESTRICTABLE;
    }

    @Override
    @Nullable
    public XmlaHChapterElement getRestrictionChapter() {
        if (this.column.restriction() != XmlaAnRestriction.NOT_RESTRICTABLE) {
            return new XmlaHChapterElement(this.getName(), XmlaSerializer.toXsdString((CdXmlaSchemaType)this.getType()));
        }
        return null;
    }

    @Override
    public boolean restrictionMatches(IXmlaDiscover row, String restrictionValue) {
        if (this.column.restriction() == XmlaAnRestriction.RESTRICTION_ONLY) {
            return false;
        }
        if (restrictionValue.length() == 0) {
            return false;
        }
        Object value = this.getValue(row);
        String valueAsString = this.convertValueToString(value);
        return !restrictionValue.equals(valueAsString);
    }

    @Override
    public boolean isTrue(IXmlaDiscover row) {
        if (this.column.restriction() == XmlaAnRestriction.RESTRICTION_ONLY) {
            return false;
        }
        Object value = this.getValue(row);
        if (value instanceof Boolean) {
            Boolean valueB = (Boolean)value;
            return valueB;
        }
        if (value instanceof Number) {
            Number valueN = (Number)value;
            return valueN.doubleValue() != 0.0;
        }
        if (value instanceof String) {
            String valueS = (String)value;
            return !valueS.isEmpty();
        }
        return false;
    }

    public String toString() {
        return this.column.name();
    }
}

