/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.xmla.model.mddataset.IXmlaMember;
import crazydev.xmla.model.mddataset.IXmlaTuple;
import crazydev.xmla.server.iccube.mddataset.XmlaMember;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class XmlaTuple
implements IXmlaTuple {
    private static final int MDDISPINFO_DRILLED_DOWN = 65536;
    private static final int MDDISPINFO_SAME_PARENT_AS_PREV = 131072;
    private List<XmlaMember> members = new ArrayList<XmlaMember>();

    public XmlaTuple(OlapNameContext nameContext, OlapMemberFilter tupleFilter, Map<OlapMember, OlapMemberPropertyValues> properties, OlapTuple tuple, @Nullable OlapTuple prevTuple, @Nullable OlapTuple nextTuple) {
        int mcount = tuple.getMemberCount();
        for (int pos = 0; pos < mcount; ++pos) {
            OlapMember member = tuple.getMember(pos);
            int displayInfo = XmlaTuple.computeDisplayInfo(tupleFilter, member, pos, prevTuple, nextTuple);
            OlapMemberPropertyValues propertyValues = properties.get(member);
            this.members.add(new XmlaMember(nameContext, member, displayInfo, propertyValues));
        }
    }

    public int size() {
        return this.members.size();
    }

    public IXmlaMember getMember(int idx) {
        return this.members.get(idx);
    }

    public List<XmlaMember> getMembers() {
        return this.members;
    }

    private static int computeDisplayInfo(OlapMemberFilter tupleFilter, OlapMember member, int pos, @Nullable OlapTuple prevTuple, @Nullable OlapTuple nextTuple) {
        OlapMember prevMember;
        OlapMember prevMemberParent;
        OlapMember memberParent;
        OlapMember nextMember;
        OlapMember nextMemberParent;
        int displayInfo = member.getXmlaChildrenCardinality(tupleFilter);
        if (displayInfo > 65535) {
            displayInfo = 65535;
        }
        if (nextTuple != null && (nextMemberParent = (nextMember = nextTuple.getMember(pos)).getParent()) != null && member.equals((Object)nextMemberParent)) {
            displayInfo |= 0x10000;
        }
        if (prevTuple != null && (memberParent = member.getParent()) != null && (prevMemberParent = (prevMember = prevTuple.getMember(pos)).getParent()) != null && memberParent.equals((Object)prevMemberParent)) {
            displayInfo |= 0x20000;
        }
        return displayInfo;
    }
}

