/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.xmla.model.mddataset.IXmlaHierarchyInfo;
import crazydev.xmla.server.iccube.mddataset.XmlaDimensionProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XmlaHierarchyInfo
implements IXmlaHierarchyInfo {
    private final String hierarchyUniqueName;
    private final List<XmlaDimensionProperty> properties = new ArrayList<XmlaDimensionProperty>();

    public XmlaHierarchyInfo(OlapNameContext nameContext, OlapHierarchy hierarchy) {
        this(nameContext, Collections.emptyList(), hierarchy);
    }

    public XmlaHierarchyInfo(OlapNameContext nameContext, List<OlapResScopedDimensionProperty> requestedProperties, OlapHierarchy hierarchy) {
        this.hierarchyUniqueName = hierarchy.getUniqueName(nameContext);
        this.addMandatoryStuff();
        for (OlapResScopedDimensionProperty requestedProperty : requestedProperties) {
            OlapNameIdentifiableEntity scope = requestedProperty.getScope();
            if (scope != null && !scope.isScoping(hierarchy)) continue;
            this.properties.add(new XmlaDimensionProperty(nameContext, requestedProperty));
        }
    }

    private void addMandatoryStuff() {
        this.addMandatoryStuff("UName", "MEMBER_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR);
        this.addMandatoryStuff("Caption", "MEMBER_CAPTION", CdXmlaSchemaType.DBTYPE_WSTR);
        this.addMandatoryStuff("LName", "LEVEL_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR);
        this.addMandatoryStuff("LNum", "LEVEL_NUMBER", CdXmlaSchemaType.DBTYPE_I4);
        this.addMandatoryStuff("DisplayInfo", "DISPLAY_INFO", CdXmlaSchemaType.DBTYPE_UI4);
    }

    private void addMandatoryStuff(String xmlaName, String name, CdXmlaSchemaType xmlaType) {
        this.properties.add(new XmlaDimensionProperty(xmlaName, this.hierarchyUniqueName + ".[" + name + "]", xmlaType, name, false, name.equals("MEMBER_CAPTION"), false));
    }

    public String getUniqueName() {
        return this.hierarchyUniqueName;
    }

    public List<XmlaDimensionProperty> getProperties() {
        return this.properties;
    }
}

