/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.xmla.model.mddataset.IXmlaCell;
import crazydev.xmla.model.mddataset.IXmlaError;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.server.iccube.mddataset.XmlaCellProperty;
import crazydev.xmla.server.iccube.mddataset.XmlaError;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaCell
implements IXmlaCell {
    private final int ordinal;
    private final boolean isOnError;
    @Nullable
    private final XmlaError error;
    private final List<XmlaCellProperty> requestedProperties;
    private final XmlaPropertyValue[] values;

    public XmlaCell(@Nullable CdXmlaOptions options, List<XmlaCellProperty> requestedProperties, OlapResCell cell) {
        this.ordinal = cell.getOrdinal();
        this.isOnError = cell.isOnError();
        OlapException error = cell.getException();
        this.error = error == null ? null : new XmlaError(error);
        OlapScalarEntity[] values = cell.getRequestedPropertyValues();
        this.values = new XmlaPropertyValue[values.length];
        for (int idx = 0; idx < values.length; ++idx) {
            OlapScalarEntity value = values[idx];
            if (value == null) {
                this.values[idx] = new XmlaPropertyValue((OlapScalarEntity)OlapEmptyEntity.INSTANCE);
                continue;
            }
            boolean isValueProperty = requestedProperties.get(idx).isValue();
            this.values[idx] = new XmlaPropertyValue(options, isValueProperty, value);
        }
        this.requestedProperties = requestedProperties;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getPropertyCount() {
        return this.values.length;
    }

    public IXmlaPropertyValue getPropertyValue(int propertyIndex) {
        if (propertyIndex < 0 || propertyIndex >= this.values.length) {
            throw new IllegalArgumentException("Wrong property index [" + propertyIndex + "] (range:0:" + (this.values.length - 1) + ")");
        }
        return this.values[propertyIndex];
    }

    public IXmlaPropertyValue getPropertyValue(String propertyName) {
        for (int idx = 0; idx < this.requestedProperties.size(); ++idx) {
            String name = this.requestedProperties.get(idx).getName();
            if (!name.equalsIgnoreCase(propertyName)) continue;
            return this.values[idx];
        }
        return null;
    }

    public boolean isOnError() {
        return this.isOnError;
    }

    @Nullable
    public IXmlaError getError() {
        return this.error;
    }
}

