/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.cache.statement.OlapStatementCacheManager;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.xmla.model.mddataset.IXmlaAxesInfo;
import crazydev.xmla.model.mddataset.IXmlaAxisInfo;
import crazydev.xmla.server.iccube.mddataset.XmlaAxisInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaAxesInfo
implements IXmlaAxesInfo {
    private final List<XmlaAxisInfo> hierarchies = new ArrayList<XmlaAxisInfo>();

    public XmlaAxesInfo(OlapNameContext nameContext, OlapResSelectStatementDataSet result) {
        OlapTuple stuple;
        OlapResAxis[] axes = result.getAxes();
        if (axes != null) {
            for (OlapResAxis axis : axes) {
                this.hierarchies.add(new XmlaAxisInfo(nameContext, axis));
            }
        }
        if ((stuple = XmlaAxesInfo.getSlicerTuple(result.getContext(), result.getSlicer(), result.getDefaultMembers())) != null) {
            this.hierarchies.add(new XmlaAxisInfo(nameContext, stuple));
        } else {
            this.hierarchies.add(new XmlaAxisInfo(nameContext, (OlapTuple)null));
        }
    }

    public boolean isEmpty() {
        return this.hierarchies.isEmpty();
    }

    public List<? extends IXmlaAxisInfo> getAxisInfo() {
        return this.hierarchies;
    }

    @Nullable
    public static OlapTuple getSlicerTuple(OlapMdxStatementExecutionContext context, @Nullable OlapResSlicer slicer, List<OlapMember> defaultMembers) {
        if (slicer == null) {
            if (defaultMembers.isEmpty()) {
                return null;
            }
            if (defaultMembers.size() == 1) {
                return (OlapTuple)defaultMembers.get(0);
            }
            OlapStatementCacheManager cacheManager = context.getStatementCacheManager();
            OlapTupleDimensionalityCache cache = cacheManager.getTupleDimensionalityCache();
            return OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, (OlapTupleDimensionalityCache)cache, (OlapTupleDimensionality)null, (OlapMember[])defaultMembers.toArray(new OlapMember[defaultMembers.size()]));
        }
        if (slicer.getTupleCount() == 1) {
            OlapTuple stuple = slicer.getAnyTuple();
            if (!defaultMembers.isEmpty()) {
                OlapStatementCacheManager cacheManager = context.getStatementCacheManager();
                OlapTupleDimensionalityCache cache = cacheManager.getTupleDimensionalityCache();
                return OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, (OlapTupleDimensionalityCache)cache, null, (OlapTuple)stuple, defaultMembers);
            }
            return stuple;
        }
        return null;
    }
}

