/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.Options;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.session.CloseListener;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

class UserProfileDirectoryCleaner
implements CloseListener {
    private static final Path TEMP_DIRECTORY;
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private final Path userProfileDirectory;
    private final CdpLogger log;
    private final int maxSleepTimeMs;

    public UserProfileDirectoryCleaner(Options options) {
        CdpLoggerFactory factory = new CdpLoggerFactory(options);
        this.log = factory.getLogger("cdp4j.user.profile.cleaner");
        Path userProfileDirectory = options.userDataDir();
        if (userProfileDirectory == null) {
            throw new IllegalArgumentException();
        }
        if (TEMP_DIRECTORY == null) {
            throw new IllegalStateException();
        }
        if (!userProfileDirectory.startsWith(TEMP_DIRECTORY)) {
            throw new CdpException("User profile directory must be specifically located in default temporary folder which is:" + TEMP_DIRECTORY.toString());
        }
        this.userProfileDirectory = userProfileDirectory;
        this.maxSleepTimeMs = options.userProfileCleanerMaxSleepTime();
    }

    private boolean clean() {
        if (this.executed.compareAndSet(false, true)) {
            this.log.info("trying to delete user profile directory: {}", this.userProfileDirectory.toString());
            if (!Files.exists(this.userProfileDirectory, new LinkOption[0])) {
                return true;
            }
            int totalSleepTimeMs = 0;
            boolean done = false;
            int delayMs = this.getSleepTime();
            long delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMs);
            while (!done && totalSleepTimeMs < this.maxSleepTimeMs) {
                try {
                    Files.walkFileTree(this.userProfileDirectory, new ProfileDirectoryVisitor(this.userProfileDirectory));
                    done = true;
                }
                catch (IOException e) {
                    LockSupport.parkNanos(delayNanos);
                    totalSleepTimeMs += delayMs;
                }
            }
        }
        return !Files.exists(this.userProfileDirectory, new LinkOption[0]);
    }

    private final int getSleepTime() {
        return 100;
    }

    @Override
    public void closed() {
        boolean done = this.clean();
        if (done) {
            this.log.info("User profile directory deleted: {}", this.userProfileDirectory.toString());
        }
    }

    static {
        try {
            Path dummyTempDir = Files.createTempDirectory("cdp4j", new FileAttribute[0]);
            TEMP_DIRECTORY = dummyTempDir.getParent();
            Files.delete(dummyTempDir);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    public class ProfileDirectoryVisitor
    extends SimpleFileVisitor<Path> {
        private final Path root;

        public ProfileDirectoryVisitor(Path root) {
            this.root = root;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir.startsWith(this.root)) {
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (dir.startsWith(this.root)) {
                Files.delete(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

