/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.SelectorEngine;

public class SessionSettings {
    private static final Integer DEFAULT_SCREEN_WIDTH = 1366;
    private static final Integer DEFAULT_SCREEN_HEIGHT = 768;
    private final int screenWidth;
    private final int screenHeight;
    private final Boolean multiFrameMode;
    private final SelectorEngine selectorEngine;
    private final Boolean reuseEmptyTab;

    public static Builder builder() {
        return new Builder();
    }

    public SessionSettings() {
        this(DEFAULT_SCREEN_WIDTH, DEFAULT_SCREEN_HEIGHT);
    }

    public SessionSettings(Boolean multiFrameMode) {
        this(DEFAULT_SCREEN_WIDTH, DEFAULT_SCREEN_HEIGHT, multiFrameMode);
    }

    public SessionSettings(int screenWidth, int screenHeight) {
        this(screenWidth, screenHeight, Boolean.FALSE);
    }

    public SessionSettings(int screenWidth, int screenHeight, Boolean multiFrameMode) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.multiFrameMode = multiFrameMode;
        this.selectorEngine = SelectorEngine.Native;
        this.reuseEmptyTab = Boolean.TRUE;
    }

    private SessionSettings(int screenWidth, int screenHeight, Boolean multiFrameMode, SelectorEngine selectorEngine, Boolean reuseEmptyTab) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.multiFrameMode = multiFrameMode;
        this.selectorEngine = selectorEngine;
        this.reuseEmptyTab = reuseEmptyTab;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public Boolean isMultiFrameMode() {
        return this.multiFrameMode;
    }

    public SelectorEngine getSelectorEngine() {
        return this.selectorEngine;
    }

    public Boolean getReuseEmptyTab() {
        return this.reuseEmptyTab;
    }

    public String toString() {
        return "SessionSettings [screenWidth=" + this.screenWidth + ", screenHeight=" + this.screenHeight + ", multiFrameMode=" + this.multiFrameMode + ", selectorEngine=" + (Object)((Object)this.selectorEngine) + ", reuseEmptyTab=" + this.reuseEmptyTab + "]";
    }

    public static class Builder {
        private Integer screenWidth;
        private Integer screenHeight;
        private Boolean multiFrameMode;
        private SelectorEngine selectorEngine;
        private Boolean reuseEmptyTab;

        private Builder() {
        }

        public Builder screenWidth(int screenWidth) {
            this.screenWidth = screenWidth;
            return this;
        }

        public Builder screenHeight(int screenHeight) {
            this.screenHeight = screenHeight;
            return this;
        }

        public Builder multiFrameMode(Boolean multiFrameMode) {
            this.multiFrameMode = multiFrameMode;
            return this;
        }

        public Builder selectorEngine(SelectorEngine selectorEngine) {
            this.selectorEngine = selectorEngine;
            return this;
        }

        public Builder reuseEmptyTab(Boolean reuseEmptyTab) {
            this.reuseEmptyTab = reuseEmptyTab;
            return this;
        }

        public SessionSettings build() {
            return new SessionSettings(this.screenWidth == null ? DEFAULT_SCREEN_WIDTH : this.screenWidth, this.screenHeight == null ? DEFAULT_SCREEN_HEIGHT : this.screenHeight, this.multiFrameMode == null ? Boolean.FALSE : this.multiFrameMode, this.selectorEngine == null ? SelectorEngine.Native : this.selectorEngine, this.reuseEmptyTab == null ? Boolean.TRUE : this.reuseEmptyTab);
        }
    }
}

