/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.Input;
import io.webfolder.cdp.session.Constant;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.constant.MouseEventType;
import io.webfolder.cdp.type.constant.PointerType;
import io.webfolder.cdp.type.input.MouseButton;
import io.webfolder.cdp.type.util.Point;

public interface Mouse {
    default public Session click(String selector) {
        return this.click(selector, Constant.EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Session click(String selector, Object ... args) {
        this.getThis().logEntry("click", String.format(selector, args));
        String objectId = this.getThis().getObjectId(selector, args);
        Point point = null;
        try {
            this.getThis().scrollIntoViewIfNeededWithObjectId(selector, objectId, args);
            point = this.getThis().getClickablePointWithObjectId(selector, objectId, args);
        }
        finally {
            if (objectId != null) {
                this.getThis().releaseObject(objectId);
            }
        }
        int clickCount = 1;
        Input input = this.getThis().getCommand().getInput();
        input.dispatchMouseEvent(MouseEventType.MousePressed, point.x, point.y, null, null, MouseButton.Left, null, clickCount, null, null, null, null, null, null, null, PointerType.Mouse);
        input.dispatchMouseEvent(MouseEventType.MouseReleased, point.x, point.y, null, null, MouseButton.Left, null, clickCount, null, null, null, null, null, null, null, PointerType.Mouse);
        return this.getThis();
    }

    default public Session move(double x, double y) {
        Input input = this.getThis().getCommand().getInput();
        input.dispatchMouseEvent(MouseEventType.MouseMoved, x, y);
        return this.getThis();
    }

    public Session getThis();
}

