/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.serialization.JsonMapper;
import io.webfolder.cdp.serialization.ResponseParser;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.Context;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.FutureUtils;
import io.webfolder.cdp.session.HandlerConstants;
import io.webfolder.cdp.session.PromiseContext;
import io.webfolder.cdp.session.SemaphoreContext;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.session.ThreadContext;
import io.webfolder.cdp.session.WaitingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class JacksonSessionInvocationHandler
implements SessionInvocationHandler,
HandlerConstants {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Channel channel;
    private final Map<Integer, Context> contexts;
    private final CdpLogger log;
    private final Session session;
    private final String sessionId;
    private final int readTimeout;
    private final WaitingStrategy waitingStrategy;
    private final ObjectWriter writer;
    private final Executor workerThreadPool;

    JacksonSessionInvocationHandler(JsonMapper mapper, Channel channel, Map<Integer, Context> contexts, Session session, CdpLogger log, String sessionId, int readTimeOut, WaitingStrategy waitingStrategy, Executor workerThreadPool) {
        this.writer = (ObjectWriter)mapper.getWriter();
        this.channel = channel;
        this.contexts = contexts;
        this.session = session;
        this.log = log;
        this.sessionId = sessionId;
        this.readTimeout = readTimeOut;
        this.waitingStrategy = waitingStrategy;
        this.workerThreadPool = workerThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeWithCustomParser(DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync, ResponseParser responseParser) {
        Context context;
        byte[] json;
        if (!this.session.isConnected() || this.session.isDisposed()) {
            throw new CdpException(this.session.isDisposed() ? "Session was disposed." : "WebSocket connection is not alive.");
        }
        Integer id = this.counter.incrementAndGet();
        try {
            json = this.toJson(command.method, id, argNames, args);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("--> {}", new String(json, StandardCharsets.UTF_8));
        }
        CompletableFuture<Object> promise = null;
        if (sync) {
            context = WaitingStrategy.Semaphore == this.waitingStrategy ? new SemaphoreContext(command, crt, responseParser) : new ThreadContext(command, crt, responseParser);
        } else {
            promise = FutureUtils.orTimeout(new CompletableFuture(), this.readTimeout, TimeUnit.MILLISECONDS, this.workerThreadPool, () -> {
                Context c;
                if (this.session != null && (c = this.session.pullContext(id)) != null) {
                    c.release();
                }
            }, this.log, command);
            PromiseContext promiseContext = new PromiseContext(command, crt, promise, responseParser);
            context = promiseContext;
        }
        Context context2 = context;
        this.contexts.put(id, context2);
        if (sync) {
            try {
                this.channel.sendText(json);
                context2.await(this.readTimeout);
            }
            finally {
                this.session.pullContext(id);
            }
        } else {
            this.channel.sendText(json);
            return promise;
        }
        if (context2.getError() != null) {
            throw context2.getError();
        }
        return context2.getData();
    }

    byte[] toJson(String method, Integer id, String[] parameters, Object[] args) throws IOException {
        try (ByteArrayOutputStream bs = new ByteArrayOutputStream(256);){
            byte[] byArray;
            block14: {
                JsonGenerator generator = this.writer.createGenerator((OutputStream)bs);
                try {
                    generator.writeStartObject();
                    generator.writeNumberField("id", id.intValue());
                    if (this.sessionId != null) {
                        generator.writeStringField("sessionId", this.sessionId);
                    }
                    generator.writeStringField("method", method);
                    if (args.length > 0) {
                        generator.writeFieldName("params");
                        generator.writeStartObject();
                        for (int i = 0; i < args.length; ++i) {
                            Object value = args[i];
                            if (value == null) continue;
                            generator.writeObjectField(parameters[i], value);
                        }
                        generator.writeEndObject();
                    }
                    generator.writeEndObject();
                    generator.close();
                    byArray = bs.toByteArray();
                    if (generator == null) break block14;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return byArray;
        }
    }

    @Override
    public void dispose() {
        for (Context context : this.contexts.values()) {
            try {
                context.release();
            }
            catch (Throwable throwable) {}
        }
        this.contexts.clear();
    }

    @Override
    public Object invoke(DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync) {
        return this.invokeWithCustomParser(command, crt, argNames, args, sync, null);
    }
}

