/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.serialization.JsonMapper;
import io.webfolder.cdp.serialization.ResponseParser;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.Context;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.FutureUtils;
import io.webfolder.cdp.session.HandlerConstants;
import io.webfolder.cdp.session.PromiseContext;
import io.webfolder.cdp.session.SemaphoreContext;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.session.ThreadContext;
import io.webfolder.cdp.session.WaitingStrategy;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class GsonSessionInvocationHandler
implements SessionInvocationHandler,
HandlerConstants {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Gson gson;
    private final Channel channel;
    private final Map<Integer, Context> contexts;
    private final CdpLogger log;
    private final Session session;
    private final String sessionId;
    private final int readTimeout;
    private final WaitingStrategy waitingStrategy;
    private final Executor workerThreadPool;

    GsonSessionInvocationHandler(JsonMapper mapper, Channel channel, Map<Integer, Context> contexts, Session session, CdpLogger log, String sessionId, int readTimeOut, WaitingStrategy waitingStrategy, Executor workerThreadPool) {
        this.gson = (Gson)mapper.getMapper();
        this.channel = channel;
        this.contexts = contexts;
        this.session = session;
        this.log = log;
        this.sessionId = sessionId;
        this.readTimeout = readTimeOut;
        this.waitingStrategy = waitingStrategy;
        this.workerThreadPool = workerThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync) {
        Context context;
        if (!this.session.isConnected() || this.session.isDisposed()) {
            throw new CdpException(this.session.isDisposed() ? "Session was disposed." : "WebSocket connection is not alive.");
        }
        Integer id = this.counter.incrementAndGet();
        String json = this.toJson(command.method, id, argNames, args);
        if (this.log.isDebugEnabled()) {
            this.log.debug("--> {}", json);
        }
        CompletableFuture<Object> promise = null;
        if (sync) {
            context = WaitingStrategy.Semaphore == this.waitingStrategy ? new SemaphoreContext(command, crt, null) : new ThreadContext(command, crt, null);
        } else {
            promise = FutureUtils.orTimeout(new CompletableFuture(), this.readTimeout, TimeUnit.MILLISECONDS, this.workerThreadPool, () -> {
                Context c;
                if (this.session != null && (c = this.session.pullContext(id)) != null) {
                    c.release();
                }
            }, this.log, command);
            PromiseContext promiseContext = new PromiseContext(command, crt, promise, null);
            context = promiseContext;
        }
        Context context2 = context;
        this.contexts.put(id, context2);
        if (sync) {
            try {
                this.channel.sendText(json);
                context2.await(this.readTimeout);
            }
            finally {
                this.session.pullContext(id);
            }
        } else {
            this.channel.sendText(json);
            return promise;
        }
        if (context2.getError() != null) {
            throw context2.getError();
        }
        return context2.getData();
    }

    String toJson(String method, Integer id, String[] argNames, Object[] argValues) {
        JsonObject argsJson = new JsonObject();
        if (argValues.length > 0) {
            for (int i = 0; i < argValues.length; ++i) {
                argsJson.add(argNames[i], this.gson.toJsonTree(argValues[i]));
            }
        }
        JsonObject payload = new JsonObject();
        payload.add("id", (JsonElement)new JsonPrimitive((Number)id));
        if (this.sessionId != null) {
            payload.add("sessionId", (JsonElement)new JsonPrimitive(this.sessionId));
        }
        payload.add("method", (JsonElement)new JsonPrimitive(method));
        if (argValues.length > 0) {
            payload.add("params", (JsonElement)argsJson);
        }
        return this.gson.toJson((JsonElement)payload);
    }

    @Override
    public void dispose() {
        for (Context context : this.contexts.values()) {
            try {
                context.release();
            }
            catch (Throwable throwable) {}
        }
        this.contexts.clear();
    }

    @Override
    public Object invokeWithCustomParser(DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync, ResponseParser parser) {
        throw new CdpException("not supported");
    }
}

