/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.PageAsync;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.event.page.ScreencastFrame;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.session.CloseListener;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.VideoRecorder;
import io.webfolder.cdp.session.VideoRecorderOptions;
import io.webfolder.cdp.session.VideoRecorderResult;
import io.webfolder.cdp.type.constant.ImageFormat;
import io.webfolder.cdp.type.page.ScreencastFrameMetadata;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import us.ihmc.codecs.builder.H264Settings;
import us.ihmc.codecs.builder.MP4H264MovieBuilder;
import us.ihmc.codecs.builder.MovieBuilder;
import us.ihmc.codecs.generated.EProfileIdc;
import us.ihmc.codecs.generated.EUsageType;
import us.ihmc.codecs.generated.RC_MODES;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.codecs.yuv.JPEGDecoder;

class CiscoOpenH264VideoRecorder
implements VideoRecorder,
EventListener {
    private static final int DEFAULT_FPS = 25;
    private static final int DEFAULT_NTH_FRAME = 1;
    private static final H264Settings H264_SETTINGS = new H264Settings();
    private final Session session;
    private final CdpLogger log;
    private final JPEGDecoder decoder;
    private final PageAsync page;
    private final Object encoderLock = new Object();
    private final CloseListener sessionCloseListener;
    private final Path videoFile;
    private final VideoRecorderOptions options;
    private volatile MovieBuilder movieBuilder;
    private volatile long lastFrameTimestamp;
    private volatile VideoRecorder.VideoRecorderState state;
    private volatile boolean disposed;
    private byte[] lastFrame;

    CiscoOpenH264VideoRecorder(Session session, VideoRecorderOptions options, CdpLogger log) {
        this.session = session;
        this.options = options;
        this.log = log;
        try {
            this.videoFile = Files.createTempFile("", options.videoFileName(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        this.decoder = new JPEGDecoder();
        session.addEventListener(this);
        this.page = session.getAsyncCommand().getPage();
        this.sessionCloseListener = () -> {
            if (this.state != VideoRecorder.VideoRecorderState.InvokedEncoding) {
                this.dispose();
            }
        };
        session.addCloseListener(this.sessionCloseListener);
    }

    @Override
    public void start() {
        boolean startable;
        boolean bl = startable = this.state == null || this.state == VideoRecorder.VideoRecorderState.InvokedStopped;
        if (!startable) {
            throw new IllegalArgumentException("state=[" + (Object)((Object)this.state) + "]");
        }
        ((CompletableFuture)this.page.enable().thenAccept(rE -> {
            this.state = VideoRecorder.VideoRecorderState.InvokedPageEnabled;
            ((CompletableFuture)this.page.startScreencast(ImageFormat.Jpeg, this.options.imageQuality(), null, null, 1).thenAccept(rC -> {
                this.state = VideoRecorder.VideoRecorderState.InvokedScreencast;
            })).exceptionally(t -> {
                this.state = VideoRecorder.VideoRecorderState.ErrorStartScreencast;
                this.log.error(t.getMessage(), (Throwable)t);
                this.session.removeEventEventListener(this);
                this.session.removeCloseListener(this.sessionCloseListener);
                return null;
            });
        })).exceptionally(t -> {
            this.state = VideoRecorder.VideoRecorderState.ErrorPageEnable;
            this.log.error(t.getMessage(), (Throwable)t);
            this.session.removeEventEventListener(this);
            this.session.removeCloseListener(this.sessionCloseListener);
            return null;
        });
    }

    @Override
    public void stop() {
        this.state = VideoRecorder.VideoRecorderState.InvokedStopped;
        this.page.stopScreencast().exceptionally(e -> {
            this.log.warn(e.getMessage(), e);
            return null;
        });
    }

    @Override
    public VideoRecorderResult encode() {
        if (this.state == null) {
            throw new IllegalStateException("Invoke VideoRecorder.start() before video encoding");
        }
        try {
            this.state = VideoRecorder.VideoRecorderState.InvokedEncoding;
            this.process(null, System.currentTimeMillis(), true);
        }
        finally {
            this.dispose();
            this.state = VideoRecorder.VideoRecorderState.EncodingDone;
            if (this.session.isConnected()) {
                this.session.removeEventEventListener(this);
                this.session.removeCloseListener(this.sessionCloseListener);
            }
        }
        return new VideoRecorderResult(true, this.videoFile);
    }

    @Override
    public CompletableFuture<VideoRecorderResult> encodeAsync() {
        throw new CdpException("Not supported");
    }

    @Override
    public void onEvent(Events event, Object value) {
        if (Events.PageScreencastFrame != event) {
            return;
        }
        if (this.state == VideoRecorder.VideoRecorderState.InvokedStopped || this.state == VideoRecorder.VideoRecorderState.InvokedEncoding) {
            return;
        }
        ScreencastFrame sc = (ScreencastFrame)value;
        if (this.movieBuilder == null) {
            ScreencastFrameMetadata meta = sc.getMetadata();
            try {
                this.movieBuilder = new MP4H264MovieBuilder(this.videoFile.toFile(), meta.getDeviceWidth().intValue(), meta.getDeviceHeight().intValue(), 25, H264_SETTINGS);
            }
            catch (IOException e) {
                throw new CdpException(e);
            }
        }
        long frameTimestamp = (long)(sc.getMetadata().getTimestamp() * 1000.0);
        this.process(sc.getData(), frameTimestamp, false);
        this.page.screencastFrameAck(sc.getSessionId()).exceptionally(t -> {
            this.log.warn(t.getMessage(), t);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(String frame, long frameTimestamp, boolean done) {
        Object object = this.encoderLock;
        synchronized (object) {
            long duration = frameTimestamp - this.lastFrameTimestamp;
            int repeatCount = Math.max(1, Math.round(duration * 25L / 1000L));
            if (this.lastFrame != null) {
                YUVPicture pic = null;
                try {
                    pic = this.decoder.decode(ByteBuffer.wrap(this.lastFrame));
                    for (int i = 0; i < repeatCount; ++i) {
                        this.movieBuilder.encodeFrame(pic);
                    }
                }
                catch (IOException e) {
                    throw new CdpException(e);
                }
                finally {
                    if (pic != null) {
                        pic.delete();
                    }
                    this.lastFrame = null;
                }
            }
            if (!done) {
                this.lastFrameTimestamp = frameTimestamp;
                try {
                    this.lastFrame = Base64.getDecoder().decode(frame);
                }
                catch (IllegalArgumentException e) {
                    this.log.error(e.getMessage(), e);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.encoderLock;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            if (this.decoder != null) {
                this.decoder.delete();
            }
            if (this.movieBuilder != null) {
                try {
                    this.movieBuilder.close();
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), e);
                }
            }
        }
    }

    static {
        H264_SETTINGS.setUsageType(EUsageType.SCREEN_CONTENT_REAL_TIME);
        H264_SETTINGS.setRcMode(RC_MODES.RC_OFF_MODE);
        H264_SETTINGS.setProfileIdc(EProfileIdc.PRO_BASELINE);
    }
}

