/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.serialization;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.serialization.GsonEnumTypeAdapter;

class GsonEnumTypeAdapterFactory
implements TypeAdapterFactory {
    private final CdpLogger log;
    private static final String CDP_ENUM_PACKAGE_PREFIX = "io.webfolder.cdp.type";

    GsonEnumTypeAdapterFactory(CdpLogger log) {
        this.log = log;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class rawType = typeToken.getRawType();
        if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class || !rawType.getName().startsWith(CDP_ENUM_PACKAGE_PREFIX)) {
            return null;
        }
        if (!rawType.isEnum()) {
            rawType = rawType.getSuperclass();
        }
        return new GsonEnumTypeAdapter(rawType, this.log);
    }
}

