/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.logger;

import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.FormattingTuple;
import io.webfolder.cdp.logger.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

class CdpJulLogger
implements CdpLogger {
    private final Logger log;
    private final boolean isDebugEnabled;

    public CdpJulLogger(String name) {
        this.log = Logger.getLogger(name);
        this.isDebugEnabled = this.log.isLoggable(Level.FINE);
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.log.isLoggable(Level.INFO)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.info(tuple.getMessage());
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.log.isLoggable(Level.FINE)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.fine(tuple.getMessage());
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.log.isLoggable(Level.WARNING)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.warning(tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.log.isLoggable(Level.SEVERE)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.severe(tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log.log(Level.SEVERE, message, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }
}

