/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.logger;

import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLogggerLevel;
import io.webfolder.cdp.logger.FormattingTuple;
import io.webfolder.cdp.logger.MessageFormatter;

class CdpConsoleLogger
implements CdpLogger {
    private final CdpLogggerLevel loggerLevel;

    public CdpConsoleLogger() {
        this(CdpLogggerLevel.Info);
    }

    public CdpConsoleLogger(CdpLogggerLevel loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    @Override
    public void info(String message, Object ... args) {
        if (CdpLogggerLevel.Info.equals((Object)this.loggerLevel) || CdpLogggerLevel.Debug.equals((Object)this.loggerLevel)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[INFO] " + tuple.getMessage());
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (CdpLogggerLevel.Debug.equals((Object)this.loggerLevel)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[DEBUG] " + tuple.getMessage());
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (CdpLogggerLevel.Info.equals((Object)this.loggerLevel) || CdpLogggerLevel.Warn.equals((Object)this.loggerLevel) || CdpLogggerLevel.Debug.equals((Object)this.loggerLevel)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[WARN] " + tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (CdpLogggerLevel.Info.equals((Object)this.loggerLevel) || CdpLogggerLevel.Warn.equals((Object)this.loggerLevel) || CdpLogggerLevel.Error.equals((Object)this.loggerLevel) || CdpLogggerLevel.Debug.equals((Object)this.loggerLevel)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[ERROR] " + tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (CdpLogggerLevel.Info.equals((Object)this.loggerLevel) || CdpLogggerLevel.Warn.equals((Object)this.loggerLevel) || CdpLogggerLevel.Error.equals((Object)this.loggerLevel) || CdpLogggerLevel.Debug.equals((Object)this.loggerLevel)) {
            System.err.println("[ERROR] " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return CdpLogggerLevel.Debug.equals((Object)this.loggerLevel);
    }
}

