/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.ProfilerAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.profiler.Profile;
import io.webfolder.cdp.type.profiler.ScriptCoverage;
import io.webfolder.cdp.type.profiler.ScriptTypeProfile;
import io.webfolder.cdp.type.profiler.TakePreciseCoverageResult;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class ProfilerAsyncImpl
implements ProfilerAsync {
    private static final TypeReference<List<ScriptCoverage>> LIST_SCRIPTCOVERAGE = new TypeReference<List<ScriptCoverage>>(){};
    private static final TypeReference<List<ScriptTypeProfile>> LIST_SCRIPTTYPEPROFILE = new TypeReference<List<ScriptTypeProfile>>(){};
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_BEST_EFFORT_COVERAGE = new CommandReturnType("result", (Type)((Object)List.class), LIST_SCRIPTCOVERAGE);
    private static final CommandReturnType CRT_SET_SAMPLING_INTERVAL = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_START = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_START_PRECISE_COVERAGE = new CommandReturnType("timestamp", (Type)((Object)Double.class), null);
    private static final CommandReturnType CRT_START_TYPE_PROFILE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_STOP = new CommandReturnType("profile", (Type)((Object)Profile.class), null);
    private static final CommandReturnType CRT_STOP_PRECISE_COVERAGE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_STOP_TYPE_PROFILE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TAKE_PRECISE_COVERAGE = new CommandReturnType(null, (Type)((Object)TakePreciseCoverageResult.class), null);
    private static final CommandReturnType CRT_TAKE_TYPE_PROFILE = new CommandReturnType("result", (Type)((Object)List.class), LIST_SCRIPTTYPEPROFILE);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_SET_SAMPLING_INTERVAL_1 = new String[]{"interval"};
    private static final String[] PARAMS_START_PRECISE_COVERAGE_2 = new String[]{"callCount", "detailed", "allowTriggeredUpdates"};
    private final SessionInvocationHandler handler;

    public ProfilerAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> disable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> enable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<ScriptCoverage>> getBestEffortCoverage() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_getBestEffortCoverage, CRT_GET_BEST_EFFORT_COVERAGE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> setSamplingInterval(Integer interval) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_setSamplingInterval, CRT_SET_SAMPLING_INTERVAL, PARAMS_SET_SAMPLING_INTERVAL_1, new Object[]{interval}, false);
    }

    @Override
    public CompletableFuture<Void> start() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_start, CRT_START, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Double> startPreciseCoverage() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_startPreciseCoverage, CRT_START_PRECISE_COVERAGE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Double> startPreciseCoverage(Boolean callCount, Boolean detailed, Boolean allowTriggeredUpdates) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_startPreciseCoverage, CRT_START_PRECISE_COVERAGE, PARAMS_START_PRECISE_COVERAGE_2, new Object[]{callCount, detailed, allowTriggeredUpdates}, false);
    }

    @Override
    public CompletableFuture<Void> startTypeProfile() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_startTypeProfile, CRT_START_TYPE_PROFILE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Profile> stop() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_stop, CRT_STOP, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> stopPreciseCoverage() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_stopPreciseCoverage, CRT_STOP_PRECISE_COVERAGE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> stopTypeProfile() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_stopTypeProfile, CRT_STOP_TYPE_PROFILE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<TakePreciseCoverageResult> takePreciseCoverage() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_takePreciseCoverage, CRT_TAKE_PRECISE_COVERAGE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<ScriptTypeProfile>> takeTypeProfile() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Profiler_takeTypeProfile, CRT_TAKE_TYPE_PROFILE, EMPTY_ARGS, EMPTY_VALUES, false);
    }
}

