/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.LayerTreeAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.dom.Rect;
import io.webfolder.cdp.type.layertree.CompositingReasonsResult;
import io.webfolder.cdp.type.layertree.PictureTile;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class LayerTreeAsyncImpl
implements LayerTreeAsync {
    private static final TypeReference<List<List<Double>>> LIST_LIST_DOUBLE = new TypeReference<List<List<Double>>>(){};
    private static final CommandReturnType CRT_COMPOSITING_REASONS = new CommandReturnType(null, (Type)((Object)CompositingReasonsResult.class), null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_LOAD_SNAPSHOT = new CommandReturnType("snapshotId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_MAKE_SNAPSHOT = new CommandReturnType("snapshotId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_PROFILE_SNAPSHOT = new CommandReturnType("timings", (Type)((Object)List.class), LIST_LIST_DOUBLE);
    private static final CommandReturnType CRT_RELEASE_SNAPSHOT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REPLAY_SNAPSHOT = new CommandReturnType("dataURL", (Type)((Object)String.class), null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_COMPOSITING_REASONS_1 = new String[]{"layerId"};
    private static final String[] PARAMS_LOAD_SNAPSHOT_1 = new String[]{"tiles"};
    private static final String[] PARAMS_MAKE_SNAPSHOT_1 = new String[]{"layerId"};
    private static final String[] PARAMS_PROFILE_SNAPSHOT_1 = new String[]{"snapshotId"};
    private static final String[] PARAMS_PROFILE_SNAPSHOT_2 = new String[]{"snapshotId", "minRepeatCount", "minDuration", "clipRect"};
    private static final String[] PARAMS_RELEASE_SNAPSHOT_1 = new String[]{"snapshotId"};
    private static final String[] PARAMS_REPLAY_SNAPSHOT_1 = new String[]{"snapshotId"};
    private static final String[] PARAMS_REPLAY_SNAPSHOT_2 = new String[]{"snapshotId", "fromStep", "toStep", "scale"};
    private final SessionInvocationHandler handler;

    public LayerTreeAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<CompositingReasonsResult> compositingReasons(String layerId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_compositingReasons, CRT_COMPOSITING_REASONS, PARAMS_COMPOSITING_REASONS_1, new Object[]{layerId}, false);
    }

    @Override
    public CompletableFuture<Void> disable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> enable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<String> loadSnapshot(List<PictureTile> tiles) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_loadSnapshot, CRT_LOAD_SNAPSHOT, PARAMS_LOAD_SNAPSHOT_1, new Object[]{tiles}, false);
    }

    @Override
    public CompletableFuture<String> makeSnapshot(String layerId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_makeSnapshot, CRT_MAKE_SNAPSHOT, PARAMS_MAKE_SNAPSHOT_1, new Object[]{layerId}, false);
    }

    @Override
    public CompletableFuture<List<List<Double>>> profileSnapshot(String snapshotId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_profileSnapshot, CRT_PROFILE_SNAPSHOT, PARAMS_PROFILE_SNAPSHOT_1, new Object[]{snapshotId}, false);
    }

    @Override
    public CompletableFuture<List<List<Double>>> profileSnapshot(String snapshotId, Integer minRepeatCount, Double minDuration, Rect clipRect) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_profileSnapshot, CRT_PROFILE_SNAPSHOT, PARAMS_PROFILE_SNAPSHOT_2, new Object[]{snapshotId, minRepeatCount, minDuration, clipRect}, false);
    }

    @Override
    public CompletableFuture<Void> releaseSnapshot(String snapshotId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_releaseSnapshot, CRT_RELEASE_SNAPSHOT, PARAMS_RELEASE_SNAPSHOT_1, new Object[]{snapshotId}, false);
    }

    @Override
    public CompletableFuture<String> replaySnapshot(String snapshotId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_replaySnapshot, CRT_REPLAY_SNAPSHOT, PARAMS_REPLAY_SNAPSHOT_1, new Object[]{snapshotId}, false);
    }

    @Override
    public CompletableFuture<String> replaySnapshot(String snapshotId, Integer fromStep, Integer toStep, Double scale) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.LayerTree_replaySnapshot, CRT_REPLAY_SNAPSHOT, PARAMS_REPLAY_SNAPSHOT_2, new Object[]{snapshotId, fromStep, toStep, scale}, false);
    }
}

