/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.Animation;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.runtime.RemoteObject;
import java.lang.reflect.Type;
import java.util.List;

class AnimationImpl
implements Animation {
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_CURRENT_TIME = new CommandReturnType("currentTime", (Type)((Object)Double.class), null);
    private static final CommandReturnType CRT_GET_PLAYBACK_RATE = new CommandReturnType("playbackRate", (Type)((Object)Double.class), null);
    private static final CommandReturnType CRT_RELEASE_ANIMATIONS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_RESOLVE_ANIMATION = new CommandReturnType("remoteObject", (Type)((Object)RemoteObject.class), null);
    private static final CommandReturnType CRT_SEEK_ANIMATIONS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_PAUSED = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_PLAYBACK_RATE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_TIMING = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_GET_CURRENT_TIME_1 = new String[]{"id"};
    private static final String[] PARAMS_RELEASE_ANIMATIONS_1 = new String[]{"animations"};
    private static final String[] PARAMS_RESOLVE_ANIMATION_1 = new String[]{"animationId"};
    private static final String[] PARAMS_SEEK_ANIMATIONS_1 = new String[]{"animations", "currentTime"};
    private static final String[] PARAMS_SET_PAUSED_1 = new String[]{"animations", "paused"};
    private static final String[] PARAMS_SET_PLAYBACK_RATE_1 = new String[]{"playbackRate"};
    private static final String[] PARAMS_SET_TIMING_1 = new String[]{"animationId", "duration", "delay"};
    private final SessionInvocationHandler handler;

    public AnimationImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void disable() {
        this.handler.invoke(DomainCommand.Animation_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable() {
        this.handler.invoke(DomainCommand.Animation_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public Double getCurrentTime(String id) {
        return (Double)this.handler.invoke(DomainCommand.Animation_getCurrentTime, CRT_GET_CURRENT_TIME, PARAMS_GET_CURRENT_TIME_1, new Object[]{id}, true);
    }

    @Override
    public Double getPlaybackRate() {
        return (Double)this.handler.invoke(DomainCommand.Animation_getPlaybackRate, CRT_GET_PLAYBACK_RATE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void releaseAnimations(List<String> animations) {
        this.handler.invoke(DomainCommand.Animation_releaseAnimations, CRT_RELEASE_ANIMATIONS, PARAMS_RELEASE_ANIMATIONS_1, new Object[]{animations}, true);
    }

    @Override
    public RemoteObject resolveAnimation(String animationId) {
        return (RemoteObject)this.handler.invoke(DomainCommand.Animation_resolveAnimation, CRT_RESOLVE_ANIMATION, PARAMS_RESOLVE_ANIMATION_1, new Object[]{animationId}, true);
    }

    @Override
    public void seekAnimations(List<String> animations, Double currentTime) {
        this.handler.invoke(DomainCommand.Animation_seekAnimations, CRT_SEEK_ANIMATIONS, PARAMS_SEEK_ANIMATIONS_1, new Object[]{animations, currentTime}, true);
    }

    @Override
    public void setPaused(List<String> animations, Boolean paused) {
        this.handler.invoke(DomainCommand.Animation_setPaused, CRT_SET_PAUSED, PARAMS_SET_PAUSED_1, new Object[]{animations, paused}, true);
    }

    @Override
    public void setPlaybackRate(Double playbackRate) {
        this.handler.invoke(DomainCommand.Animation_setPlaybackRate, CRT_SET_PLAYBACK_RATE, PARAMS_SET_PLAYBACK_RATE_1, new Object[]{playbackRate}, true);
    }

    @Override
    public void setTiming(String animationId, Double duration, Double delay) {
        this.handler.invoke(DomainCommand.Animation_setTiming, CRT_SET_TIMING, PARAMS_SET_TIMING_1, new Object[]{animationId, duration, delay}, true);
    }
}

