/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.chromium;

import io.webfolder.cdp.JsonLibrary;
import io.webfolder.cdp.logger.CdpLoggerType;
import io.webfolder.cdp.logger.CdpLogggerLevel;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ChromiumOptions {
    private CdpLoggerType loggerType;
    private CdpLogggerLevel consoleLoggerLevel;
    private String loggerNamePrefix;
    private JsonLibrary jsonLibrary;
    private Path downloadPath;

    private ChromiumOptions() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public CdpLoggerType loggerType() {
        return this.loggerType;
    }

    public String loggerNamePrefix() {
        return this.loggerNamePrefix;
    }

    public CdpLogggerLevel consoleLoggerLevel() {
        return this.consoleLoggerLevel;
    }

    public JsonLibrary jsonLibrary() {
        return this.jsonLibrary;
    }

    public Path downloadPath() {
        return this.downloadPath;
    }

    public String toString() {
        return "ChromiumOptions [loggerType=" + (Object)((Object)this.loggerType) + ", consoleLoggerLevel=" + (Object)((Object)this.consoleLoggerLevel) + ", loggerNamePrefix=" + this.loggerNamePrefix + ", jsonLibrary=" + (Object)((Object)this.jsonLibrary) + ", downloadPath=" + this.downloadPath + "]";
    }

    public static class Builder {
        private ChromiumOptions options = new ChromiumOptions();

        private Builder() {
        }

        public Builder loggerType(CdpLoggerType loggerType) {
            this.options.loggerType = loggerType;
            return this;
        }

        public Builder consoleLoggerLevel(CdpLogggerLevel consoleLoggerLevel) {
            this.options.consoleLoggerLevel = consoleLoggerLevel;
            return this;
        }

        public Builder loggerNamePrefix(String loggerNamePrefix) {
            this.options.loggerNamePrefix = loggerNamePrefix;
            return this;
        }

        public Builder jsonLibrary(JsonLibrary jsonLibrary) {
            this.options.jsonLibrary = jsonLibrary;
            return this;
        }

        public ChromiumOptions build() {
            if (this.options.loggerType == null) {
                this.options.loggerType = CdpLoggerType.Null;
            }
            if (this.options.consoleLoggerLevel == null) {
                this.options.consoleLoggerLevel = CdpLogggerLevel.Info;
            }
            if (this.options.jsonLibrary == null) {
                this.options.jsonLibrary = JsonLibrary.Gson;
            }
            if (this.options.downloadPath == null) {
                this.options.downloadPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath().resolve("cdp4j-chromium");
            }
            return this.options;
        }
    }
}

