/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.UndertowWebSocketListener;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;

public class UndertowWebSocketChannel
implements Channel {
    private final IoFuture<WebSocketChannel> future;
    private final SessionFactory factory;
    private final MessageHandler handler;
    private WebSocketChannel webSocket;

    public UndertowWebSocketChannel(IoFuture<WebSocketChannel> future, SessionFactory factory, MessageHandler handler) {
        this.future = future;
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.webSocket.isOpen()) {
            WebSockets.sendClose((int)1000, (String)"done", (WebSocketChannel)this.webSocket, null);
            try {
                this.webSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendText(String message) {
        WebSockets.sendText((String)message, (WebSocketChannel)this.webSocket, null);
    }

    @Override
    public void sendText(byte[] message) {
        WebSockets.sendText((ByteBuffer)ByteBuffer.wrap(message), (WebSocketChannel)this.webSocket, null);
    }

    @Override
    public void connect() {
        try {
            this.webSocket = (WebSocketChannel)this.future.get();
        }
        catch (IOException | CancellationException e) {
            throw new CdpException(e);
        }
        try {
            this.webSocket.getReceiveSetter().set((ChannelListener)new UndertowWebSocketListener(this.factory, this.handler));
            this.webSocket.resumeReceives();
        }
        catch (CancellationException e) {
            throw new CdpException(e);
        }
    }
}

