/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.webfolder.cdp.exception.CdpException;
import java.nio.ByteBuffer;
import java.util.List;

public class NettyWebSocketZeroMaskFrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static byte[] ZERO_MASK = ByteBuffer.allocate(4).putInt(0).array();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        int opcode;
        ByteBuf data = msg.content();
        if (msg instanceof TextWebSocketFrame) {
            opcode = 1;
        } else if (msg instanceof PingWebSocketFrame) {
            opcode = 9;
        } else if (msg instanceof PongWebSocketFrame) {
            opcode = 10;
        } else if (msg instanceof CloseWebSocketFrame) {
            opcode = 8;
        } else if (msg instanceof BinaryWebSocketFrame) {
            opcode = 2;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            opcode = 0;
        } else {
            throw new CdpException("Cannot encode frame of type: " + msg.getClass().getName());
        }
        int length = data.readableBytes();
        int b0 = 0;
        if (msg.isFinalFragment()) {
            b0 |= 0x80;
        }
        b0 |= msg.rsv() % 8 << 4;
        b0 |= opcode % 128;
        boolean release = true;
        ByteBuf buf = null;
        try {
            int maskLength = 4;
            if (length <= 125) {
                int size = 2 + maskLength;
                buf = ctx.alloc().buffer(size += length);
                buf.writeByte(b0);
                byte b = (byte)(0x80 | (byte)length);
                buf.writeByte((int)b);
            } else if (length <= 65535) {
                int size = 4 + maskLength;
                buf = ctx.alloc().buffer(size += length);
                buf.writeByte(b0);
                buf.writeByte(254);
                buf.writeByte(length >>> 8 & 0xFF);
                buf.writeByte(length & 0xFF);
            } else {
                int size = 10 + maskLength;
                buf = ctx.alloc().buffer(size += length);
                buf.writeByte(b0);
                buf.writeByte(255);
                buf.writeLong((long)length);
            }
            buf.writeBytes(ZERO_MASK);
            if (buf.writableBytes() >= data.readableBytes()) {
                buf.writeBytes(data);
                out.add(buf);
            } else {
                out.add(buf);
                out.add(data.retain());
            }
            release = false;
        }
        finally {
            if (release && buf != null) {
                buf.release();
            }
        }
    }
}

