/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.NettyWebSocketChannel;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class NettyWebSocketChannelFactory
implements ChannelFactory {
    private final EventLoopGroup loop;
    private final boolean performMasking;

    public NettyWebSocketChannelFactory() {
        this((EventLoopGroup)new NioEventLoopGroup(), false);
    }

    public NettyWebSocketChannelFactory(boolean performMasking) {
        this((EventLoopGroup)new NioEventLoopGroup(), performMasking);
    }

    public NettyWebSocketChannelFactory(EventLoopGroup loop) {
        this(loop, false);
    }

    public NettyWebSocketChannelFactory(EventLoopGroup loop, boolean performMasking) {
        this.loop = loop;
        this.performMasking = performMasking;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        return new NettyWebSocketChannel(factory, handler, URI.create(connection.getUrl()), this.loop, this.performMasking);
    }

    public void close() {
        this.loop.shutdownGracefully(10L, 10L, TimeUnit.MILLISECONDS);
    }
}

