/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.InputStreamExtension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

class ListInputStream
extends InputStream
implements InputStreamExtension {
    private static final int EOF = -1;
    private final List<InputStream> streams;
    private final AutoCloseable closeable;
    private Iterator<InputStream> iterator;
    private InputStream current;

    public ListInputStream(AutoCloseable closeable, List<InputStream> streams) {
        this.closeable = closeable;
        this.streams = streams;
        this.iterator = streams.iterator();
        this.peekNextStream();
    }

    final void nextStream() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
        this.peekNextStream();
    }

    private void peekNextStream() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            if (this.current == null) {
                throw new NullPointerException();
            }
        } else {
            this.current = null;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.current == null) {
            return 0;
        }
        return this.current.available();
    }

    @Override
    public int read() throws IOException {
        while (this.current != null) {
            int c = this.current.read();
            if (c != -1) {
                return c;
            }
            this.nextStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        do {
            int n;
            if ((n = this.current.read(b, off, len)) > 0) {
                return n;
            }
            this.nextStream();
        } while (this.current != null);
        return -1;
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        for (InputStream is : this.streams) {
            is.reset();
        }
        this.iterator = this.streams.iterator();
        this.peekNextStream();
    }

    @Override
    public byte[] readLastNBytes(int length) throws IOException {
        InputStream is = this.streams.get(this.streams.size() - 1);
        int available = is.available();
        if (length > available) {
            length = available;
        }
        is.skip(available - length);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)is.read();
        }
        return data;
    }
}

