/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.JreWebSocketChannel;
import io.webfolder.cdp.channel.JreWebSocketListener;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class JreWebSocketFactory
implements ChannelFactory {
    private static final int CONNECTION_TIMEOUT = 10000;
    private final HttpClient client;

    public JreWebSocketFactory() {
        this(null);
    }

    public JreWebSocketFactory(Executor executor) {
        this(executor, 10000);
    }

    public JreWebSocketFactory(Executor executor, int connectionTimeout) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (executor != null) {
            builder.executor(executor);
        }
        this.client = builder.connectTimeout(Duration.ofMillis(connectionTimeout)).build();
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        String url = connection.getUrl();
        CompletableFuture<WebSocket> future = this.client.newWebSocketBuilder().buildAsync(URI.create(url), new JreWebSocketListener(factory, handler));
        return new JreWebSocketChannel(future);
    }
}

