/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.nio.channels.ClosedChannelException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket(maxTextMessageSize=0x10000000)
public class JettyWebSocketListener {
    private final SessionFactory factory;
    private final MessageHandler handler;
    private final CdpLogger log;

    public JettyWebSocketListener(SessionFactory factory, MessageHandler handler) {
        this.factory = factory;
        this.handler = handler;
        this.log = new CdpLoggerFactory(factory.getOptions()).getLogger("cdp.jetty");
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.factory.close();
    }

    @OnWebSocketError
    public void onError(Throwable t) {
        if (!(t instanceof ClosedChannelException)) {
            this.log.error(t.getMessage(), t);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String data) {
        this.handler.process(data);
    }
}

