/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.exception.CdpException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;

public class JettyWebSocketChannel
implements Channel {
    private static final int DEFAULT_TIMEOUT = 10;
    private final Future<Session> future;
    private Session webSocket;
    private RemoteEndpoint remote;

    public JettyWebSocketChannel(Future<Session> future) {
        this.future = future;
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.webSocket.isOpen()) {
            this.webSocket.close(1000, "done");
            this.webSocket.disconnect();
        }
    }

    @Override
    public void sendText(String message) {
        try {
            this.remote.sendString(message);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    @Override
    public void sendText(byte[] message) {
        this.sendText(new String(message, StandardCharsets.UTF_8));
    }

    @Override
    public void connect() {
        try {
            this.webSocket = this.future.get(10L, TimeUnit.SECONDS);
            this.remote = this.webSocket.getRemote();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new CdpException(e);
        }
    }
}

