/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;

@ClientEndpoint
public class JakartaWebSocketListener
extends Endpoint
implements MessageHandler.Partial<String> {
    private final SessionFactory factory;
    private final MessageHandler handler;
    private final StringBuilder buffer = new StringBuilder(0);

    public JakartaWebSocketListener(SessionFactory factory, MessageHandler handler) {
        this.factory = factory;
        this.handler = handler;
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.factory.close();
        this.buffer.setLength(0);
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.setMaxBinaryMessageBufferSize(0x10000000);
    }

    public void onMessage(String data, boolean last) {
        if (last) {
            if (this.buffer.length() == 0) {
                this.handler.process(data);
            } else {
                this.buffer.append(data);
                String message = this.buffer.toString();
                this.buffer.setLength(0);
                this.handler.process(message);
            }
        } else {
            this.buffer.append(data);
        }
    }
}

