/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.JakartaWebSocketChannel;
import io.webfolder.cdp.channel.JakartaWebSocketListener;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;

public class JakartaWebSocketFactory
implements ChannelFactory {
    private final WebSocketContainer webSocketContainer;

    public JakartaWebSocketFactory(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        try {
            JakartaWebSocketListener listener = new JakartaWebSocketListener(factory, handler);
            Session session = this.webSocketContainer.connectToServer((Endpoint)listener, ClientEndpointConfig.Builder.create().build(), URI.create(connection.getUrl()));
            session.addMessageHandler((jakarta.websocket.MessageHandler)listener);
            return new JakartaWebSocketChannel(session);
        }
        catch (DeploymentException | IOException e) {
            throw new CdpException(e);
        }
    }
}

