/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.serialization.GsonMapper;
import io.webfolder.cdp.serialization.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class DevToolsConnection
implements Connection {
    private final int port;
    private final String host;
    private final JsonMapper mapper;
    private static final int HTTP_OK = 200;

    public DevToolsConnection(int port) {
        this(port, "127.0.0.1");
    }

    public DevToolsConnection(int port, JsonMapper mapper) {
        this(port, "127.0.0.1", mapper);
    }

    public DevToolsConnection(int port, String host) {
        this(port, host, new GsonMapper());
    }

    protected int getTimeout() {
        return 1000;
    }

    public DevToolsConnection(int port, String host, JsonMapper mapper) {
        this.port = port;
        this.host = host;
        this.mapper = mapper;
    }

    @Override
    public String getUrl() {
        String sessions = String.format("http://%s:%d/json/version", this.host, this.port);
        try {
            URL url = new URL(sessions);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int timeout = this.getTimeout();
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            if (conn.getResponseCode() != 200) {
                throw new CdpException("Invalid http status code: " + conn.getResponseCode());
            }
            int contentLength = conn.getContentLength();
            if (contentLength < 0) {
                throw new CdpException("Invalid http response. Content-Length must be greater than 0.");
            }
            Map map = Collections.emptyMap();
            try (InputStream is = conn.getInputStream();){
                map = this.mapper.fromJson(is, Map.class);
            }
            String webSocketDebuggerUrl = (String)map.get("webSocketDebuggerUrl");
            if (webSocketDebuggerUrl == null) {
                throw new CdpException("JSON response must contain webSocketDebuggerUrl property.");
            }
            if (!webSocketDebuggerUrl.startsWith("ws://")) {
                throw new CdpException("Invalid protocol. webSocketDebuggerUrl must be valid websocket URL.");
            }
            return webSocketDebuggerUrl;
        }
        catch (ConnectException e) {
            throw new CdpException(e);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    @Override
    public boolean isValid() {
        String url = null;
        try {
            url = this.getUrl();
            return url.startsWith("ws://");
        }
        catch (Throwable t) {
            return false;
        }
    }
}

