/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferBackedInputStream
extends InputStream {
    private final AutoCloseable closeable;
    private final ByteBuffer buffer;
    private final boolean close;

    public ByteBufferBackedInputStream(AutoCloseable closeable, ByteBuffer buffer, boolean close) {
        this.closeable = closeable;
        this.buffer = buffer;
        this.close = close;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        return this.buffer.hasRemaining() ? this.buffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(bytes, off, len);
        return len;
    }

    @Override
    public long skip(long n) {
        long k = Math.min(n, (long)this.available());
        if (k < 0L) {
            k = 0L;
        }
        this.buffer.position((int)((long)this.buffer.position() + k));
        return k;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.position(0);
    }

    @Override
    public void close() throws IOException {
        if (this.close) {
            try {
                this.closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

