/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.roaringbitmap.AppendableStorage;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.CharIterator;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.buffer.BitmapFastAggregation;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.MutableRoaringArray;

public class MutableRoaringBitmap
extends ImmutableRoaringBitmap
implements Cloneable,
Iterable<Integer>,
BitmapDataProvider,
AppendableStorage<MappeableContainer> {
    private static long SHALLOW_SIZE_OF = -1L;

    public MutableRoaringBitmap() {
        this(new MutableRoaringArray());
    }

    public MutableRoaringBitmap(MutableRoaringArray highLowContainer) {
        this.highLowContainer = highLowContainer;
    }

    @Override
    public long sizeOf() {
        long size = 0L;
        size += SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += ((MutableRoaringArray)this.highLowContainer).sizeOf();
    }

    public void add(int ... dat) {
        this.addN(dat, 0, dat.length);
    }

    public void addN(int[] dat, int offset, int n) {
        if (n < 0 || offset < 0) {
            throw new IllegalArgumentException("Negative values do not make sense.");
        }
        if (n == 0) {
            return;
        }
        if (offset + n > dat.length) {
            throw new IllegalArgumentException("Data source is too small.");
        }
        MutableRoaringArray mra = (MutableRoaringArray)this.highLowContainer;
        MappeableContainer currentcont = null;
        int j = 0;
        int val = dat[j + offset];
        char currenthb = BufferUtil.highbits(val);
        int currentcontainerindex = this.highLowContainer.getIndex(currenthb);
        if (currentcontainerindex >= 0) {
            currentcont = this.highLowContainer.getContainerAtIndex(currentcontainerindex);
            MappeableContainer newcont = currentcont.add(BufferUtil.lowbits(val));
            if (newcont != currentcont) {
                mra.setContainerAtIndex(currentcontainerindex, newcont);
                currentcont = newcont;
            }
        } else {
            currentcontainerindex = -currentcontainerindex - 1;
            MappeableArrayContainer newac = new MappeableArrayContainer();
            currentcont = newac.add(BufferUtil.lowbits(val));
            mra.insertNewKeyValueAt(currentcontainerindex, currenthb, currentcont);
        }
        ++j;
        while (j < n) {
            val = dat[j + offset];
            char newhb = BufferUtil.highbits(val);
            if (currenthb == newhb) {
                newcont = currentcont.add(BufferUtil.lowbits(val));
                if (newcont != currentcont) {
                    mra.setContainerAtIndex(currentcontainerindex, newcont);
                    currentcont = newcont;
                }
            } else {
                currenthb = newhb;
                currentcontainerindex = this.highLowContainer.getIndex(currenthb);
                if (currentcontainerindex >= 0) {
                    currentcont = this.highLowContainer.getContainerAtIndex(currentcontainerindex);
                    newcont = currentcont.add(BufferUtil.lowbits(val));
                    if (newcont != currentcont) {
                        mra.setContainerAtIndex(currentcontainerindex, newcont);
                        currentcont = newcont;
                    }
                } else {
                    currentcontainerindex = -currentcontainerindex - 1;
                    MappeableArrayContainer newac = new MappeableArrayContainer();
                    currentcont = newac.add(BufferUtil.lowbits(val));
                    mra.insertNewKeyValueAt(currentcontainerindex, currenthb, currentcont);
                }
            }
            ++j;
        }
    }

    public static MutableRoaringBitmap bitmapOf(int ... dat) {
        MutableRoaringBitmap ans = new MutableRoaringBitmap();
        ans.add(dat);
        return ans;
    }

    public static MutableRoaringBitmap bitmapOfOne(int dat) {
        MutableRoaringBitmap ans = new MutableRoaringBitmap();
        ans.add(dat);
        return ans;
    }

    public static MutableRoaringBitmap bitmapOfRange(long min, long max) {
        MutableRoaringBitmap.rangeSanityCheck(min, max);
        if (min >= max) {
            return new MutableRoaringBitmap();
        }
        char hbStart = BufferUtil.highbits(min);
        char lbStart = BufferUtil.lowbits(min);
        char hbLast = BufferUtil.highbits(max - 1L);
        char lbLast = BufferUtil.lowbits(max - 1L);
        MutableRoaringArray array = new MutableRoaringArray(hbLast - hbStart + 1);
        MutableRoaringBitmap bitmap = new MutableRoaringBitmap(array);
        int firstEnd = hbStart < hbLast ? 65536 : lbLast + '\u0001';
        MappeableContainer firstContainer = MappeableContainer.rangeOfOnes(lbStart, firstEnd);
        bitmap.append(hbStart, firstContainer);
        if (hbStart < hbLast) {
            for (int i = hbStart + '\u0001'; i < hbLast; ++i) {
                MappeableContainer runContainer = MappeableContainer.rangeOfOnes(0, 65536);
                bitmap.append((char)i, runContainer);
            }
            MappeableContainer lastContainer = MappeableContainer.rangeOfOnes(0, lbLast + '\u0001');
            bitmap.append(hbLast, lastContainer);
        }
        return bitmap;
    }

    protected static void rangeSanityCheck(long rangeStart, long rangeEnd) {
        if (rangeStart < 0L || rangeStart > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("rangeStart=" + rangeStart + " should be in [0, 0xffffffff]");
        }
        if (rangeEnd > 0x100000000L || rangeEnd < 0L) {
            throw new IllegalArgumentException("rangeEnd=" + rangeEnd + " should be in [0, 0xffffffff + 1]");
        }
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BitmapFastAggregation.or(bitmaps);
    }

    @Override
    public void add(int x) {
        char hb = BufferUtil.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            this.getMappeableRoaringArray().setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).add(BufferUtil.lowbits(x)));
        } else {
            MappeableArrayContainer newac = new MappeableArrayContainer();
            this.getMappeableRoaringArray().insertNewKeyValueAt(-i - 1, hb, newac.add(BufferUtil.lowbits(x)));
        }
    }

    @Override
    public void add(long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = BufferUtil.highbits(rangeStart);
        char lbStart = BufferUtil.lowbits(rangeStart);
        char hbLast = BufferUtil.highbits(rangeEnd - 1L);
        int lbLast = BufferUtil.lowbits(rangeEnd - 1L);
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            char containerStart = hb == hbStart ? lbStart : (char)'\u0000';
            int containerLast = hb == hbLast ? lbLast : BufferUtil.maxLowBitAsInteger();
            int i = this.highLowContainer.getIndex((char)hb);
            if (i >= 0) {
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(i).iadd(containerStart, containerLast + 1);
                ((MutableRoaringArray)this.highLowContainer).setContainerAtIndex(i, c);
                continue;
            }
            ((MutableRoaringArray)this.highLowContainer).insertNewKeyValueAt(-i - 1, (char)hb, MappeableContainer.rangeOfOnes(containerStart, containerLast + 1));
        }
    }

    @Deprecated
    public void add(int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            this.add((long)rangeStart, (long)rangeEnd);
        }
        this.add((long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    public void and(ImmutableRoaringBitmap array) {
        if (array == this) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int intersectionSize = 0;
        int length1 = this.highLowContainer.size();
        int length2 = array.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = array.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c2;
                MappeableContainer c1 = this.highLowContainer.getContainerAtIndex(pos1);
                MappeableContainer c = c1.iand(c2 = array.highLowContainer.getContainerAtIndex(pos2));
                if (!c.isEmpty()) {
                    this.getMappeableRoaringArray().replaceKeyAndContainerAtIndex(intersectionSize++, s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                pos1 = this.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = array.highLowContainer.advanceUntil(s1, pos2);
        }
        this.getMappeableRoaringArray().resize(intersectionSize);
    }

    public void andNot(ImmutableRoaringBitmap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int intersectionSize = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            MappeableContainer c1;
            char s2;
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c2;
                c1 = this.highLowContainer.getContainerAtIndex(pos1);
                MappeableContainer c = c1.iandNot(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (!c.isEmpty()) {
                    this.getMappeableRoaringArray().replaceKeyAndContainerAtIndex(intersectionSize++, s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                if (pos1 != intersectionSize) {
                    c1 = this.highLowContainer.getContainerAtIndex(pos1);
                    this.getMappeableRoaringArray().replaceKeyAndContainerAtIndex(intersectionSize, s1, c1);
                }
                ++intersectionSize;
                ++pos1;
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos1 < length1) {
            this.getMappeableRoaringArray().copyRange(pos1, length1, intersectionSize);
            intersectionSize += length1 - pos1;
        }
        this.getMappeableRoaringArray().resize(intersectionSize);
    }

    public void clear() {
        this.highLowContainer = new MutableRoaringArray();
    }

    @Override
    public MutableRoaringBitmap clone() {
        MutableRoaringBitmap x = (MutableRoaringBitmap)super.clone();
        x.highLowContainer = this.highLowContainer.clone();
        return x;
    }

    public void deserialize(ByteBuffer buffer) throws IOException {
        try {
            this.getMappeableRoaringArray().deserialize(buffer);
        }
        catch (InvalidRoaringFormat cookie) {
            throw cookie.toIOException();
        }
    }

    public void flip(int x) {
        char hb = BufferUtil.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            MappeableContainer c = this.highLowContainer.getContainerAtIndex(i);
            if (!(c = c.flip(BufferUtil.lowbits(x))).isEmpty()) {
                ((MutableRoaringArray)this.highLowContainer).setContainerAtIndex(i, c);
            } else {
                ((MutableRoaringArray)this.highLowContainer).removeAtIndex(i);
            }
        } else {
            MappeableArrayContainer newac = new MappeableArrayContainer();
            ((MutableRoaringArray)this.highLowContainer).insertNewKeyValueAt(-i - 1, hb, newac.add(BufferUtil.lowbits(x)));
        }
    }

    public void flip(long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = BufferUtil.highbits(rangeStart);
        char lbStart = BufferUtil.lowbits(rangeStart);
        char hbLast = BufferUtil.highbits(rangeEnd - 1L);
        int lbLast = BufferUtil.lowbits(rangeEnd - 1L);
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            char containerStart = hb == hbStart ? lbStart : (char)'\u0000';
            int containerLast = hb == hbLast ? lbLast : BufferUtil.maxLowBitAsInteger();
            int i = this.highLowContainer.getIndex((char)hb);
            if (i >= 0) {
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(i).inot(containerStart, containerLast + 1);
                if (!c.isEmpty()) {
                    this.getMappeableRoaringArray().setContainerAtIndex(i, c);
                    continue;
                }
                this.getMappeableRoaringArray().removeAtIndex(i);
                continue;
            }
            this.getMappeableRoaringArray().insertNewKeyValueAt(-i - 1, (char)hb, MappeableContainer.rangeOfOnes(containerStart, containerLast + 1));
        }
    }

    @Deprecated
    public void flip(int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            this.flip((long)rangeStart, (long)rangeEnd);
        } else {
            this.flip((long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
        }
    }

    public MutableRoaringArray getMappeableRoaringArray() {
        return (MutableRoaringArray)this.highLowContainer;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(this){
            private int hs;
            private CharIterator iter;
            private int pos;
            private int x;
            final /* synthetic */ MutableRoaringBitmap this$0;
            {
                MutableRoaringBitmap mutableRoaringBitmap = this$0;
                Objects.requireNonNull(mutableRoaringBitmap);
                this.this$0 = mutableRoaringBitmap;
                this.hs = 0;
                this.pos = 0;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.this$0.highLowContainer.size();
            }

            private Iterator<Integer> init() {
                if (this.pos < this.this$0.highLowContainer.size()) {
                    this.iter = this.this$0.highLowContainer.getContainerAtIndex(this.pos).getCharIterator();
                    this.hs = this.this$0.highLowContainer.getKeyAtIndex(this.pos) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = this.iter.next() | this.hs;
                if (!this.iter.hasNext()) {
                    ++this.pos;
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }.init();
    }

    protected void lazyor(ImmutableRoaringBitmap x2) {
        if (this == x2) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    this.getMappeableRoaringArray().setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).lazyIOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.getMappeableRoaringArray().insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.getMappeableRoaringArray().appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    protected void naivelazyor(ImmutableRoaringBitmap x2) {
        if (this == x2) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    MappeableBitmapContainer c1 = this.highLowContainer.getContainerAtIndex(pos1).toBitmapContainer();
                    this.getMappeableRoaringArray().setContainerAtIndex(pos1, c1.lazyIOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.getMappeableRoaringArray().insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.getMappeableRoaringArray().appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    public void or(ImmutableRoaringBitmap x2) {
        if (this == x2) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    this.getMappeableRoaringArray().setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).ior(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.getMappeableRoaringArray().insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.getMappeableRoaringArray().appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    protected void repairAfterLazy() {
        for (int k = 0; k < this.highLowContainer.size(); ++k) {
            MappeableContainer c = this.highLowContainer.getContainerAtIndex(k);
            ((MutableRoaringArray)this.highLowContainer).setContainerAtIndex(k, c.repairAfterLazy());
        }
    }

    public boolean runOptimize() {
        boolean answer = false;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            MappeableContainer c = this.getMappeableRoaringArray().getContainerAtIndex(i).runOptimize();
            if (c instanceof MappeableRunContainer) {
                answer = true;
            }
            this.getMappeableRoaringArray().setContainerAtIndex(i, c);
        }
        return answer;
    }

    public ImmutableRoaringBitmap toImmutableRoaringBitmap() {
        return this;
    }

    @Override
    public void trim() {
        this.getMappeableRoaringArray().trim();
    }

    @Override
    public void append(char key, MappeableContainer container) {
        ((MutableRoaringArray)this.highLowContainer).append(key, container);
    }

    @Override
    public void setBit(int pos) {
        this.add(pos);
    }

    @Override
    public OlapBitmap compact() {
        this.trim();
        return this;
    }

    public static MutableRoaringBitmap bitmapFor(CharArrayList keysList, ArrayList<MappeableContainer> containerList) {
        if (keysList.size() != containerList.size()) {
            throw new IllegalArgumentException(keysList.size() + " !=" + containerList.size());
        }
        if (keysList.isEmpty()) {
            return new MutableRoaringBitmap();
        }
        char[] keys = keysList.toArray(new char[0]);
        MappeableContainer[] containes = containerList.toArray(new MappeableContainer[0]);
        return new MutableRoaringBitmap(new MutableRoaringArray(keys, containes, keys.length));
    }
}

