/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import crazydev.common.system.CdRamUsageEstimator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainerCharIterator;
import org.roaringbitmap.buffer.RawMappeableRunContainerCharIterator;

public final class MappeableRunContainer
extends MappeableContainer
implements Cloneable {
    private static long SHALLOW_SIZE_OF = -1L;
    private static long CHAR_BUFFER_SHALLOW_SIZE_OF = -1L;
    private static final int DEFAULT_INIT_SIZE = 4;
    CharBuffer valueslength;
    int nbrruns = 0;

    public MappeableRunContainer() {
        this(4);
    }

    public MappeableRunContainer(int capacity) {
        this.valueslength = CharBuffer.allocate(2 * capacity);
    }

    private MappeableRunContainer(int nbrruns, CharBuffer valueslength) {
        this.nbrruns = nbrruns;
        CharBuffer tmp = valueslength.duplicate();
        this.valueslength = CharBuffer.allocate(Math.max(2 * nbrruns, tmp.limit()));
        tmp.rewind();
        this.valueslength.put(tmp);
    }

    MappeableRunContainer(MappeableArrayContainer arr, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = CharBuffer.allocate(2 * nbrRuns);
        char[] vl = this.valueslength.array();
        if (nbrRuns == 0) {
            return;
        }
        int prevVal = -2;
        int runLen = 0;
        int runCount = 0;
        if (BufferUtil.isBackedBySimpleArray(arr.content)) {
            char[] a = arr.content.array();
            for (int i = 0; i < arr.cardinality; ++i) {
                int curVal = a[i];
                if (curVal == prevVal + 1) {
                    ++runLen;
                } else {
                    if (runCount > 0) {
                        vl[2 * (runCount - 1) + 1] = (char)runLen;
                    }
                    vl[2 * runCount] = (char)curVal;
                    runLen = 0;
                    ++runCount;
                }
                prevVal = curVal;
            }
        } else {
            for (int i = 0; i < arr.cardinality; ++i) {
                char curVal = arr.content.get(i);
                if (curVal == prevVal + 1) {
                    ++runLen;
                } else {
                    if (runCount > 0) {
                        vl[2 * (runCount - 1) + 1] = (char)runLen;
                    }
                    vl[2 * runCount] = curVal;
                    runLen = 0;
                    ++runCount;
                }
                prevVal = curVal;
            }
        }
        vl[2 * (runCount - 1) + 1] = (char)runLen;
    }

    public MappeableRunContainer(int firstOfRun, int lastOfRun) {
        this.nbrruns = 1;
        char[] vl = new char[]{(char)firstOfRun, (char)(lastOfRun - 1 - firstOfRun)};
        this.valueslength = CharBuffer.wrap(vl);
    }

    MappeableRunContainer(MappeableBitmapContainer bc, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = CharBuffer.allocate(2 * nbrRuns);
        if (!BufferUtil.isBackedBySimpleArray(this.valueslength)) {
            throw new RuntimeException("Unexpected internal error.");
        }
        char[] vl = this.valueslength.array();
        if (nbrRuns == 0) {
            return;
        }
        if (bc.isArrayBacked()) {
            long[] b = bc.bitmap.array();
            int longCtr = 0;
            long curWord = b[0];
            int runCount = 0;
            int len = bc.bitmap.limit();
            while (true) {
                if (curWord == 0L && longCtr < len - 1) {
                    curWord = b[++longCtr];
                    continue;
                }
                if (curWord == 0L) {
                    return;
                }
                int localRunStart = Long.numberOfTrailingZeros(curWord);
                int runStart = localRunStart + 64 * longCtr;
                long curWordWith1s = curWord | curWord - 1L;
                int runEnd = 0;
                while (curWordWith1s == -1L && longCtr < len - 1) {
                    curWordWith1s = b[++longCtr];
                }
                if (curWordWith1s == -1L) {
                    runEnd = 64 + longCtr * 64;
                    vl[2 * runCount] = (char)runStart;
                    vl[2 * runCount + 1] = (char)(runEnd - runStart - 1);
                    return;
                }
                int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
                runEnd = localRunEnd + longCtr * 64;
                vl[2 * runCount] = (char)runStart;
                vl[2 * runCount + 1] = (char)(runEnd - runStart - 1);
                ++runCount;
                curWord = curWordWith1s & curWordWith1s + 1L;
            }
        }
        int longCtr = 0;
        long curWord = bc.bitmap.get(0);
        int runCount = 0;
        int len = bc.bitmap.limit();
        while (true) {
            if (curWord == 0L && longCtr < len - 1) {
                curWord = bc.bitmap.get(++longCtr);
                continue;
            }
            if (curWord == 0L) {
                return;
            }
            int localRunStart = Long.numberOfTrailingZeros(curWord);
            int runStart = localRunStart + 64 * longCtr;
            long curWordWith1s = curWord | curWord - 1L;
            int runEnd = 0;
            while (curWordWith1s == -1L && longCtr < len - 1) {
                curWordWith1s = bc.bitmap.get(++longCtr);
            }
            if (curWordWith1s == -1L) {
                runEnd = 64 + longCtr * 64;
                vl[2 * runCount] = (char)runStart;
                vl[2 * runCount + 1] = (char)(runEnd - runStart - 1);
                return;
            }
            int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
            runEnd = localRunEnd + longCtr * 64;
            vl[2 * runCount] = (char)runStart;
            vl[2 * runCount + 1] = (char)(runEnd - runStart - 1);
            ++runCount;
            curWord = curWordWith1s & curWordWith1s + 1L;
        }
    }

    public MappeableRunContainer(CharBuffer array, int numRuns) {
        if (array.limit() < 2 * numRuns) {
            throw new RuntimeException("Mismatch between buffer and numRuns");
        }
        this.nbrruns = numRuns;
        this.valueslength = array;
    }

    public MappeableRunContainer(ByteBuffer buffer) {
        this.nbrruns = buffer.getChar(0);
        buffer.position(2);
        ByteBuffer sliced = buffer.slice();
        sliced.order(ByteOrder.LITTLE_ENDIAN);
        this.valueslength = sliced.asCharBuffer();
    }

    @Override
    public long sizeOf() {
        long size = 0L;
        size += SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CHAR_BUFFER_SHALLOW_SIZE_OF != -1L ? CHAR_BUFFER_SHALLOW_SIZE_OF : (CHAR_BUFFER_SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)CharBuffer.allocate(0)));
        return size += (long)this.serializedSizeInBytes();
    }

    private static int branchyBufferedUnsignedInterleavedBinarySearch(CharBuffer sb, int begin, int end, char k) {
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = sb.get(2 * middleIndex);
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    private static int branchyBufferedUnsignedInterleavedBinarySearch(ByteBuffer sb, int position, int begin, int end, char k) {
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = sb.getChar(position + 2 * middleIndex * 2);
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    private static int bufferedUnsignedInterleavedBinarySearch(CharBuffer sb, int begin, int end, char k) {
        return MappeableRunContainer.branchyBufferedUnsignedInterleavedBinarySearch(sb, begin, end, k);
    }

    private static int bufferedUnsignedInterleavedBinarySearch(ByteBuffer sb, int position, int begin, int end, char k) {
        return MappeableRunContainer.branchyBufferedUnsignedInterleavedBinarySearch(sb, position, begin, end, k);
    }

    static int getArraySizeInBytes(int nbrruns) {
        return 2 + 4 * nbrruns;
    }

    private static char getLength(char[] vl, int index) {
        return vl[2 * index + 1];
    }

    private static char getValue(char[] vl, int index) {
        return vl[2 * index];
    }

    static int serializedSizeInBytes(int numberOfRuns) {
        return 2 + 4 * numberOfRuns;
    }

    @Override
    public Boolean validate() {
        int card;
        int sizeAsArrayContainer;
        int sizeAsBitmapContainer;
        if (this.nbrruns == 0) {
            return false;
        }
        int n = -2;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int n2;
            char runStart = this.getValue(rlepos);
            if (runStart <= n2 + true) {
                return false;
            }
            n2 = runStart + this.getLength(rlepos);
            if (runStart <= n2) continue;
            return false;
        }
        int sizeAsRunContainer = MappeableArrayContainer.serializedSizeInBytes(this.nbrruns);
        return sizeAsRunContainer <= Math.min(sizeAsBitmapContainer = MappeableBitmapContainer.serializedSizeInBytes(0), sizeAsArrayContainer = MappeableArrayContainer.serializedSizeInBytes(card = this.getCardinality()));
    }

    @Override
    public MappeableContainer.Type getType() {
        return MappeableContainer.Type.RUN;
    }

    @Override
    public MappeableContainer add(int begin, int end) {
        MappeableRunContainer rc = (MappeableRunContainer)this.clone();
        return rc.iadd(begin, end);
    }

    @Override
    public MappeableContainer add(char k) {
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        if (index >= 0) {
            return this;
        }
        if ((index = -index - 2) >= 0) {
            char le;
            int offset = k - this.getValue(index);
            if (offset <= (le = this.getLength(index))) {
                return this;
            }
            if (offset == le + '\u0001') {
                if (index + 1 < this.nbrruns && this.getValue(index + 1) == k + '\u0001') {
                    this.setLength(index, (char)(this.getValue(index + 1) + this.getLength(index + 1) - this.getValue(index)));
                    this.recoverRoomAtIndex(index + 1);
                    return this;
                }
                this.incrementLength(index);
                return this;
            }
            if (index + 1 < this.nbrruns && this.getValue(index + 1) == k + '\u0001') {
                this.setValue(index + 1, k);
                this.setLength(index + 1, (char)(this.getLength(index + 1) + '\u0001'));
                return this;
            }
        }
        if (index == -1 && 0 < this.nbrruns && this.getValue(0) == k + '\u0001') {
            this.incrementLength(0);
            this.decrementValue();
            return this;
        }
        this.makeRoomAtIndex(index + 1);
        this.setValue(index + 1, k);
        this.setLength(index + 1, '\u0000');
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.nbrruns == 0;
    }

    @Override
    public MappeableContainer and(MappeableArrayContainer x) {
        MappeableArrayContainer ac = new MappeableArrayContainer(x.cardinality);
        if (this.nbrruns == 0) {
            return ac;
        }
        int rlepos = 0;
        int arraypos = 0;
        char rleval = this.getValue(rlepos);
        char rlelength = this.getLength(rlepos);
        while (arraypos < x.cardinality) {
            char arrayval = x.content.get(arraypos);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return ac;
                }
                rleval = this.getValue(rlepos);
                rlelength = this.getLength(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = BufferUtil.advanceUntil(x.content, arraypos, x.cardinality, rleval);
                continue;
            }
            ac.content.put(ac.cardinality, arrayval);
            ++ac.cardinality;
            ++arraypos;
        }
        return ac;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            if (card > x.cardinality) {
                card = x.cardinality;
            }
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!x.contains((char)runValue)) continue;
                    answer.content.put(answer.cardinality++, (char)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = x.clone();
        int start = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char end = this.getValue(rlepos);
            int prevOnes = answer.cardinalityInRange(start, end);
            BufferUtil.resetBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, 0);
            start = end + this.getLength(rlepos) + 1;
        }
        int ones = answer.cardinalityInRange(start, 65536);
        BufferUtil.resetBitmapRange(answer.bitmap, start, 65536);
        answer.updateCardinality(ones, 0);
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public MappeableContainer and(MappeableRunContainer x) {
        MappeableRunContainer answer = new MappeableRunContainer(CharBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
        char[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        char start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            int lateststart = Math.max(start, xstart);
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            }
            vl[2 * answer.nbrruns] = (char)lateststart;
            vl[2 * answer.nbrruns + 1] = (char)(earliestend - lateststart - 1);
            ++answer.nbrruns;
        }
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyandNot(x).toEfficientContainer();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            MappeableArrayContainer ac = new MappeableArrayContainer(card);
            ac.cardinality = Util.unsignedDifference(this.getCharIterator(), x.getCharIterator(), ac.content.array());
            return ac;
        }
        return this.toBitmapOrArrayContainer(card).iandNot(x);
    }

    @Override
    public MappeableContainer andNot(MappeableBitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (x.contains((char)runValue)) continue;
                    answer.content.put(answer.cardinality++, (char)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = x.clone();
        int lastPos = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            int prevOnes = answer.cardinalityInRange(lastPos, start);
            int flippedOnes = answer.cardinalityInRange(start, end);
            BufferUtil.resetBitmapRange(answer.bitmap, lastPos, start);
            BufferUtil.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes + flippedOnes, end - start - flippedOnes);
            lastPos = end;
        }
        int ones = answer.cardinalityInRange(lastPos, 65536);
        BufferUtil.resetBitmapRange(answer.bitmap, lastPos, answer.bitmap.capacity() * 64);
        answer.updateCardinality(ones, 0);
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public MappeableContainer andNot(MappeableRunContainer x) {
        MappeableRunContainer answer = new MappeableRunContainer(CharBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
        char[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                vl[2 * answer.nbrruns] = (char)start;
                vl[2 * answer.nbrruns + 1] = (char)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            if (start < xstart) {
                vl[2 * answer.nbrruns] = (char)start;
                vl[2 * answer.nbrruns + 1] = (char)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xend < end) {
                start = xend;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = this.getValue(rlepos);
            end = start + this.getLength(rlepos) + 1;
        }
        if (rlepos < this.nbrruns) {
            vl[2 * answer.nbrruns] = (char)start;
            vl[2 * answer.nbrruns + 1] = (char)(end - start - 1);
            ++answer.nbrruns;
            ++rlepos;
            while (rlepos < this.nbrruns) {
                vl[2 * answer.nbrruns] = this.valueslength.get(2 * rlepos);
                vl[2 * answer.nbrruns + 1] = this.valueslength.get(2 * rlepos + 1);
                ++answer.nbrruns;
                ++rlepos;
            }
        }
        return answer;
    }

    private void appendValueLength(int value, int index) {
        char length;
        char previousValue = this.getValue(index);
        int offset = value - previousValue;
        if (offset > (length = this.getLength(index))) {
            this.setLength(index, (char)offset);
        }
    }

    private boolean canPrependValueLength(int value, int index) {
        if (index < this.nbrruns) {
            char nextValue = this.getValue(index);
            return nextValue == value + 1;
        }
        return false;
    }

    @Override
    public MappeableContainer clone() {
        return new MappeableRunContainer(this.nbrruns, this.valueslength);
    }

    private void closeValueLength(int value, int index) {
        char initialValue = this.getValue(index);
        this.setLength(index, (char)(value - initialValue));
    }

    @Override
    public boolean contains(char x) {
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            return true;
        }
        if ((index = -index - 2) != -1) {
            char le;
            int offset = x - this.getValue(index);
            return offset <= (le = this.getLength(index));
        }
        return false;
    }

    public static boolean contains(ByteBuffer buf, int position, char x, int numRuns) {
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(buf, position, 0, numRuns, x);
        if (index >= 0) {
            return true;
        }
        if ((index = -index - 2) != -1) {
            char le;
            int offset = x - buf.getChar(position + index * 2 * 2);
            return offset <= (le = buf.getChar(position + index * 2 * 2 + 2));
        }
        return false;
    }

    private MappeableContainer convertToLazyBitmapIfNeeded() {
        if (this.nbrruns > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                char start = this.getValue(rlepos);
                int end = start + this.getLength(rlepos) + 1;
                BufferUtil.setBitmapRange(answer.bitmap, start, end);
            }
            answer.cardinality = -1;
            return answer;
        }
        return this;
    }

    private void copyToOffset(int offset) {
        int minCapacity = 2 * (offset + this.nbrruns);
        Optional<CharBuffer> newvalueslength = MappeableRunContainer.computeNewCapacity(this.valueslength.capacity(), minCapacity);
        if (newvalueslength.isPresent()) {
            this.copyValuesLength(this.valueslength, 0, newvalueslength.get(), offset, this.nbrruns);
            this.valueslength = newvalueslength.get();
        } else {
            this.copyValuesLength(this.valueslength, 0, this.valueslength, offset, this.nbrruns);
        }
    }

    private static Optional<CharBuffer> computeNewCapacity(int oldCapacity, int minCapacity) {
        if (oldCapacity < minCapacity) {
            int newCapacity = oldCapacity;
            while ((newCapacity = MappeableRunContainer.computeNewCapacity(newCapacity)) < minCapacity) {
            }
            return Optional.of(CharBuffer.allocate(newCapacity));
        }
        return Optional.empty();
    }

    private static int computeNewCapacity(int oldCapacity) {
        return oldCapacity == 0 ? 4 : (oldCapacity < 64 ? oldCapacity * 2 : (oldCapacity < 1024 ? oldCapacity * 3 / 2 : oldCapacity * 5 / 4));
    }

    private void copyValuesLength(CharBuffer src, int srcIndex, CharBuffer dst, int dstIndex, int length) {
        int i;
        if (BufferUtil.isBackedBySimpleArray(src) && BufferUtil.isBackedBySimpleArray(dst)) {
            System.arraycopy(src.array(), 2 * srcIndex, dst.array(), 2 * dstIndex, 2 * length);
            return;
        }
        CharBuffer temp = CharBuffer.allocate(2 * length);
        for (i = 0; i < 2 * length; ++i) {
            temp.put(src.get(2 * srcIndex + i));
        }
        temp.flip();
        for (i = 0; i < 2 * length; ++i) {
            dst.put(2 * dstIndex + i, temp.get());
        }
    }

    private void decrementLength(int index) {
        this.valueslength.put(2 * index + 1, (char)(this.valueslength.get(2 * index + 1) - '\u0001'));
    }

    private void decrementValue() {
        this.valueslength.put(0, (char)(this.valueslength.get(0) - '\u0001'));
    }

    private void ensureCapacity(int minNbRuns) {
        Optional<CharBuffer> nv = MappeableRunContainer.computeNewCapacity(this.valueslength.capacity(), 2 * minNbRuns);
        if (nv.isPresent()) {
            this.valueslength.rewind();
            nv.get().put(this.valueslength);
            this.valueslength = nv.get();
        }
    }

    @Override
    public MappeableContainer flip(char x) {
        if (this.contains(x)) {
            return this.remove(x);
        }
        return this.add(x);
    }

    @Override
    public int getArraySizeInBytes(boolean isForBitmapSerialize) {
        return 2 + 4 * this.nbrruns;
    }

    @Override
    public int getCardinality() {
        int sum = this.nbrruns;
        int limit = this.nbrruns * 2;
        if (this.isArrayBacked()) {
            char[] vl = this.valueslength.array();
            for (int k = 1; k < limit; k += 2) {
                sum += vl[k];
            }
        } else {
            for (int k = 1; k < limit; k += 2) {
                sum += this.valueslength.get(k);
            }
        }
        return sum;
    }

    public char getLength(int index) {
        return this.valueslength.get(2 * index + 1);
    }

    @Override
    public PeekableCharIterator getCharIterator() {
        if (this.isArrayBacked()) {
            return new RawMappeableRunContainerCharIterator(this);
        }
        return new MappeableRunContainerCharIterator(this);
    }

    public char getValue(int index) {
        return this.valueslength.get(2 * index);
    }

    @Override
    public MappeableContainer iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.add((char)begin);
            return this;
        }
        int bIndex = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)begin);
        int eIndex = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, bIndex >= 0 ? bIndex : -bIndex - 1, this.nbrruns, (char)(end - 1));
        if (bIndex >= 0 && eIndex >= 0) {
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (bIndex >= 0) {
            if (this.canPrependValueLength(end - 1, (eIndex = -eIndex - 2) + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin - 1, bIndex)) {
                this.mergeValuesLength(bIndex, eIndex);
                return this;
            }
            this.prependValueLength(begin, bIndex + 1);
            this.mergeValuesLength(bIndex + 1, eIndex);
            return this;
        }
        bIndex = -bIndex - 2;
        if ((eIndex = -eIndex - 2) >= 0) {
            if (bIndex >= 0) {
                if (!this.valueLengthContains(begin - 1, bIndex)) {
                    if (bIndex == eIndex) {
                        if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                            this.prependValueLength(begin, eIndex + 1);
                            return this;
                        }
                        this.makeRoomAtIndex(eIndex + 1);
                        this.setValue(eIndex + 1, (char)begin);
                        this.setLength(eIndex + 1, (char)(end - 1 - begin));
                        return this;
                    }
                    this.prependValueLength(begin, ++bIndex);
                }
            } else {
                bIndex = 0;
                this.prependValueLength(begin, bIndex);
            }
            if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (this.canPrependValueLength(end - 1, 0)) {
            this.prependValueLength(begin, 0);
        } else {
            this.makeRoomAtIndex(0);
            this.setValue(0, (char)begin);
            this.setLength(0, (char)(end - 1 - begin));
        }
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableArrayContainer x) {
        return this.and(x);
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer x) {
        return this.and(x);
    }

    @Override
    public MappeableContainer iand(MappeableRunContainer x) {
        return this.and(x);
    }

    @Override
    public MappeableContainer iandNot(MappeableArrayContainer x) {
        return this.andNot(x);
    }

    @Override
    public MappeableContainer iandNot(MappeableBitmapContainer x) {
        return this.andNot(x);
    }

    @Override
    public MappeableContainer iandNot(MappeableRunContainer x) {
        return this.andNot(x);
    }

    MappeableContainer ilazyor(MappeableArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.ilazyorToRun(x);
    }

    private MappeableContainer ilazyorToRun(MappeableArrayContainer x) {
        if (this.isFull()) {
            return MappeableRunContainer.full();
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        char[] vl = this.valueslength.array();
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableCharIterator i = x.getCharIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (MappeableRunContainer.getValue(vl, rlepos + offset) - i.peekNext() <= 0) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(vl, i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(vl, i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
            }
        }
        return this.convertToLazyBitmapIfNeeded();
    }

    private void increaseCapacity() {
        int newCapacity = MappeableRunContainer.computeNewCapacity(this.valueslength.capacity());
        CharBuffer nv = CharBuffer.allocate(newCapacity);
        this.valueslength.rewind();
        nv.put(this.valueslength);
        this.valueslength = nv;
    }

    private void incrementLength(int index) {
        this.valueslength.put(2 * index + 1, (char)('\u0001' + this.valueslength.get(2 * index + 1)));
    }

    private void incrementValue(int index) {
        this.valueslength.put(2 * index, (char)('\u0001' + this.valueslength.get(2 * index)));
    }

    private void initValueLength(int value, int index) {
        char initialValue = this.getValue(index);
        char length = this.getLength(index);
        this.setValue(index, (char)value);
        this.setLength(index, (char)(length - (value - initialValue)));
    }

    @Override
    public MappeableContainer inot(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this;
        }
        char[] vl = this.valueslength.array();
        if (vl.length <= 2 * this.nbrruns + 1) {
            boolean firstValueInRange;
            boolean lastValueBeforeRange = false;
            boolean firstValuePastRange = false;
            if (rangeStart > 0) {
                lastValueBeforeRange = this.contains((char)(rangeStart - 1));
            }
            if (lastValueBeforeRange == (firstValueInRange = this.contains((char)rangeStart))) {
                boolean lastValueInRange = this.contains((char)(rangeEnd - 1));
                if (rangeEnd != 65536) {
                    firstValuePastRange = this.contains((char)rangeEnd);
                }
                if (lastValueInRange == firstValuePastRange) {
                    return this.not(rangeStart, rangeEnd);
                }
            }
        }
        int myNbrRuns = this.nbrruns;
        MappeableRunContainer ans = this;
        ans.nbrruns = 0;
        for (k = 0; k < myNbrRuns && this.getValue(k) < rangeStart; ++k) {
            ++ans.nbrruns;
        }
        char bufferedValue = '\u0000';
        char bufferedLength = '\u0000';
        char nextValue = '\u0000';
        char nextLength = '\u0000';
        if (k < myNbrRuns) {
            bufferedValue = vl[2 * k];
            bufferedLength = vl[2 * k + 1];
        }
        ans.smartAppendExclusive(vl, (char)rangeStart, (char)(rangeEnd - rangeStart - 1));
        while (k < myNbrRuns) {
            if (ans.nbrruns > k + 1) {
                throw new RuntimeException("internal error in inot, writer has overtaken reader!! " + k + " " + ans.nbrruns);
            }
            if (k + 1 < myNbrRuns) {
                nextValue = vl[2 * (k + 1)];
                nextLength = vl[2 * (k + 1) + 1];
            }
            ans.smartAppendExclusive(vl, bufferedValue, bufferedLength);
            bufferedValue = nextValue;
            bufferedLength = nextLength;
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public boolean intersects(MappeableArrayContainer x) {
        if (this.nbrruns == 0) {
            return false;
        }
        int rlepos = 0;
        int arraypos = 0;
        char rleval = this.getValue(rlepos);
        char rlelength = this.getLength(rlepos);
        while (arraypos < x.cardinality) {
            char arrayval = x.content.get(arraypos);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return false;
                }
                rleval = this.getValue(rlepos);
                rlelength = this.getLength(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = BufferUtil.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableBitmapContainer x) {
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int runEnd;
            char runStart = this.getValue(rlepos);
            if (!x.intersects(runStart, (runEnd = runStart + this.getLength(rlepos)) + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableRunContainer x) {
        int rlepos = 0;
        int xrlepos = 0;
        char start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public MappeableContainer ior(MappeableArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        char[] vl = this.valueslength.array();
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableCharIterator i = x.getCharIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (MappeableRunContainer.getValue(vl, rlepos + offset) - i.peekNext() <= 0) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(vl, i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(vl, i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
            }
        }
        return this.toEfficientContainer();
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.or(x);
    }

    @Override
    public MappeableContainer ior(MappeableRunContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int xnbrruns = x.nbrruns;
        int offset = Math.max(nbrruns, xnbrruns);
        this.copyToOffset(offset);
        this.nbrruns = 0;
        int rlepos = 0;
        int xrlepos = 0;
        char[] vl = this.valueslength.array();
        while (rlepos < nbrruns && xrlepos < xnbrruns) {
            char value = MappeableRunContainer.getValue(vl, offset + rlepos);
            char xvalue = x.getValue(xrlepos);
            char length = MappeableRunContainer.getLength(vl, offset + rlepos);
            char xlength = x.getLength(xrlepos);
            if (value - xvalue <= 0) {
                this.smartAppend(vl, value, length);
                ++rlepos;
                continue;
            }
            this.smartAppend(vl, xvalue, xlength);
            ++xrlepos;
        }
        while (rlepos < nbrruns) {
            this.smartAppend(vl, MappeableRunContainer.getValue(vl, offset + rlepos), MappeableRunContainer.getLength(vl, offset + rlepos));
            ++rlepos;
        }
        while (xrlepos < xnbrruns) {
            this.smartAppend(vl, x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        return this.toEfficientContainer();
    }

    @Override
    protected boolean isArrayBacked() {
        return BufferUtil.isBackedBySimpleArray(this.valueslength);
    }

    @Override
    public boolean isFull() {
        return this.nbrruns == 1 && this.getValue(0) == '\u0000' && this.getLength(0) == '\uffff';
    }

    public static MappeableRunContainer full() {
        return new MappeableRunContainer(0, 65536);
    }

    @Override
    public Iterator<Character> iterator() {
        final PeekableCharIterator i = this.getCharIterator();
        return new Iterator<Character>(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Character next() {
                return Character.valueOf(i.next());
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    private MappeableRunContainer lazyandNot(MappeableArrayContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        MappeableRunContainer answer = new MappeableRunContainer(CharBuffer.allocate(2 * (this.nbrruns + x.cardinality)), 0);
        char[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.content.get(xrlepos);
        while (rlepos < this.nbrruns && xrlepos < x.cardinality) {
            if (end <= xstart) {
                vl[2 * answer.nbrruns] = (char)start;
                vl[2 * answer.nbrruns + 1] = (char)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xstart + '\u0001' <= start) {
                if (++xrlepos >= x.cardinality) continue;
                xstart = x.content.get(xrlepos);
                continue;
            }
            if (start < xstart) {
                vl[2 * answer.nbrruns] = (char)start;
                vl[2 * answer.nbrruns + 1] = (char)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xstart + '\u0001' < end) {
                start = xstart + '\u0001';
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = this.getValue(rlepos);
            end = start + this.getLength(rlepos) + 1;
        }
        if (rlepos < this.nbrruns) {
            vl[2 * answer.nbrruns] = (char)start;
            vl[2 * answer.nbrruns + 1] = (char)(end - start - 1);
            ++answer.nbrruns;
            ++rlepos;
            while (rlepos < this.nbrruns) {
                vl[2 * answer.nbrruns] = this.valueslength.get(2 * rlepos);
                vl[2 * answer.nbrruns + 1] = this.valueslength.get(2 * rlepos + 1);
                ++answer.nbrruns;
                ++rlepos;
            }
        }
        return answer;
    }

    MappeableContainer lazyor(MappeableArrayContainer x) {
        return this.lazyorToRun(x);
    }

    private MappeableContainer lazyorToRun(MappeableArrayContainer x) {
        if (this.isFull()) {
            return MappeableRunContainer.full();
        }
        MappeableRunContainer answer = new MappeableRunContainer(CharBuffer.allocate(2 * (this.nbrruns + x.getCardinality())), 0);
        char[] vl = answer.valueslength.array();
        int rlepos = 0;
        PeekableCharIterator i = x.getCharIterator();
        while (rlepos < this.nbrruns && i.hasNext()) {
            if (this.getValue(rlepos) - i.peekNext() <= 0) {
                answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(vl, i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                answer.smartAppend(vl, i.next());
            }
        } else {
            while (rlepos < this.nbrruns) {
                answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        if (answer.isFull()) {
            return MappeableRunContainer.full();
        }
        return answer.convertToLazyBitmapIfNeeded();
    }

    private void makeRoomAtIndex(int index) {
        if (2 * (this.nbrruns + 1) > this.valueslength.capacity()) {
            this.increaseCapacity();
        }
        this.copyValuesLength(this.valueslength, index, this.valueslength, index + 1, this.nbrruns - index);
        ++this.nbrruns;
    }

    private void mergeValuesLength(int begin, int end) {
        if (begin < end) {
            char bValue = this.getValue(begin);
            char eValue = this.getValue(end);
            char eLength = this.getLength(end);
            int newLength = eValue - bValue + eLength;
            this.setLength(begin, (char)newLength);
            this.recoverRoomsInRange(begin, end);
        }
    }

    @Override
    public MappeableContainer not(int rangeStart, int rangeEnd) {
        if (rangeEnd <= rangeStart) {
            return this.clone();
        }
        MappeableRunContainer ans = new MappeableRunContainer(this.nbrruns + 1);
        if (!ans.isArrayBacked()) {
            throw new RuntimeException("internal bug");
        }
        char[] vl = ans.valueslength.array();
        if (this.isArrayBacked()) {
            char[] myVl = this.valueslength.array();
            for (k = 0; k < this.nbrruns && MappeableRunContainer.getValue(myVl, k) < rangeStart; ++k) {
                vl[2 * k] = myVl[2 * k];
                vl[2 * k + 1] = myVl[2 * k + 1];
                ++ans.nbrruns;
            }
            ans.smartAppendExclusive(vl, (char)rangeStart, (char)(rangeEnd - rangeStart - 1));
            while (k < this.nbrruns) {
                ans.smartAppendExclusive(vl, MappeableRunContainer.getValue(myVl, k), MappeableRunContainer.getLength(myVl, k));
                ++k;
            }
        } else {
            while (k < this.nbrruns && this.getValue(k) < rangeStart) {
                vl[2 * k] = this.getValue(k);
                vl[2 * k + 1] = this.getLength(k);
                ++ans.nbrruns;
                ++k;
            }
            ans.smartAppendExclusive(vl, (char)rangeStart, (char)(rangeEnd - rangeStart - 1));
            while (k < this.nbrruns) {
                ans.smartAppendExclusive(vl, this.getValue(k), this.getLength(k));
                ++k;
            }
        }
        return ans.toEfficientContainer();
    }

    @Override
    public int numberOfRuns() {
        return this.nbrruns;
    }

    @Override
    public MappeableContainer or(MappeableArrayContainer x) {
        return this.lazyorToRun(x).repairAfterLazy();
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer x) {
        if (this.isFull()) {
            return MappeableRunContainer.full();
        }
        MappeableBitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start, end);
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnesInRange, end - start);
        }
        if (answer.isFull()) {
            return MappeableRunContainer.full();
        }
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableRunContainer x) {
        if (this.isFull() || x.isFull()) {
            return MappeableRunContainer.full();
        }
        MappeableRunContainer answer = new MappeableRunContainer(CharBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
        char[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (this.getValue(rlepos) - x.getValue(xrlepos) <= 0) {
                answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(vl, x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (xrlepos < x.nbrruns) {
            answer.smartAppend(vl, x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (rlepos < this.nbrruns) {
            answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
            ++rlepos;
        }
        if (answer.isFull()) {
            return MappeableRunContainer.full();
        }
        return answer.toEfficientContainer();
    }

    private void prependValueLength(int value, int index) {
        char initialValue = this.getValue(index);
        char length = this.getLength(index);
        this.setValue(index, (char)value);
        this.setLength(index, (char)(initialValue - value + length));
    }

    private void recoverRoomAtIndex(int index) {
        this.copyValuesLength(this.valueslength, index + 1, this.valueslength, index, this.nbrruns - index - 1);
        --this.nbrruns;
    }

    private void recoverRoomsInRange(int begin, int end) {
        if (end + 1 < this.nbrruns) {
            this.copyValuesLength(this.valueslength, end + 1, this.valueslength, begin + 1, this.nbrruns - 1 - end);
        }
        this.nbrruns -= end - begin;
    }

    private MappeableContainer remove(char x) {
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            if (this.getLength(index) == '\u0000') {
                this.recoverRoomAtIndex(index);
            } else {
                this.incrementValue(index);
                this.decrementLength(index);
            }
            return this;
        }
        if ((index = -index - 2) >= 0) {
            char le;
            int offset = x - this.getValue(index);
            if (offset < (le = this.getLength(index))) {
                this.setLength(index, (char)(offset - 1));
                int newvalue = x + '\u0001';
                int newlength = le - offset - 1;
                this.makeRoomAtIndex(index + 1);
                this.setValue(index + 1, (char)newvalue);
                this.setLength(index + 1, (char)newlength);
                return this;
            }
            if (offset == le) {
                this.decrementLength(index);
            }
        }
        return this;
    }

    @Override
    public MappeableContainer repairAfterLazy() {
        return this.toEfficientContainer();
    }

    @Override
    public MappeableContainer runOptimize() {
        return this.toEfficientContainer();
    }

    @Override
    public int serializedSizeInBytes() {
        return MappeableRunContainer.serializedSizeInBytes(this.nbrruns);
    }

    private void setLength(int index, char v) {
        this.setLength(this.valueslength, index, v);
    }

    private void setLength(CharBuffer valueslength, int index, char v) {
        valueslength.put(2 * index + 1, v);
    }

    private void setValue(int index, char v) {
        this.setValue(this.valueslength, index, v);
    }

    private void setValue(CharBuffer valueslength, int index, char v) {
        valueslength.put(2 * index, v);
    }

    private void smartAppend(char[] vl, char val) {
        int oldend;
        if (this.nbrruns == 0 || val > (oldend = vl[2 * (this.nbrruns - 1)] + vl[2 * (this.nbrruns - 1) + 1]) + 1) {
            vl[2 * this.nbrruns] = val;
            vl[2 * this.nbrruns + 1] = '\u0000';
            ++this.nbrruns;
            return;
        }
        if (val == (char)(oldend + 1)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            vl[n] = (char)(vl[n] + '\u0001');
        }
    }

    void smartAppend(char start, char length) {
        int oldend;
        if (this.nbrruns == 0 || start > (oldend = this.getValue(this.nbrruns - 1) + this.getLength(this.nbrruns - 1)) + 1) {
            this.ensureCapacity(this.nbrruns + 1);
            this.valueslength.put(2 * this.nbrruns, start);
            this.valueslength.put(2 * this.nbrruns + 1, length);
            ++this.nbrruns;
            return;
        }
        int newend = start + length + 1;
        if (newend > oldend) {
            this.setLength(this.nbrruns - 1, (char)(newend - 1 - this.getValue(this.nbrruns - 1)));
        }
    }

    private void smartAppend(char[] vl, char start, char length) {
        int oldend;
        if (this.nbrruns == 0 || start > (oldend = vl[2 * (this.nbrruns - 1)] + vl[2 * (this.nbrruns - 1) + 1]) + 1) {
            vl[2 * this.nbrruns] = start;
            vl[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        int newend = start + length + 1;
        if (newend > oldend) {
            vl[2 * (this.nbrruns - 1) + 1] = (char)(newend - 1 - vl[2 * (this.nbrruns - 1)]);
        }
    }

    private void smartAppendExclusive(char[] vl, char val) {
        int oldend;
        if (this.nbrruns == 0 || val > (oldend = this.getValue(this.nbrruns - 1) + this.getLength(this.nbrruns - 1) + 1)) {
            vl[2 * this.nbrruns] = val;
            vl[2 * this.nbrruns + 1] = '\u0000';
            ++this.nbrruns;
            return;
        }
        if (oldend == val) {
            int n = 2 * (this.nbrruns - 1) + 1;
            vl[n] = (char)(vl[n] + '\u0001');
            return;
        }
        int newend = val + '\u0001';
        if (val == this.getValue(this.nbrruns - 1)) {
            if (newend != oldend) {
                this.setValue(this.nbrruns - 1, (char)newend);
                this.setLength(this.nbrruns - 1, (char)(oldend - newend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (char)(val - this.getValue(this.nbrruns - 1) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (char)newend);
            this.setLength(this.nbrruns, (char)(oldend - newend - 1));
            ++this.nbrruns;
        }
    }

    private void smartAppendExclusive(char[] vl, char start, char length) {
        int oldend;
        if (this.nbrruns == 0 || start > (oldend = this.getValue(this.nbrruns - 1) + this.getLength(this.nbrruns - 1) + 1)) {
            vl[2 * this.nbrruns] = start;
            vl[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        if (oldend == start) {
            int n = 2 * (this.nbrruns - 1) + 1;
            vl[n] = (char)(vl[n] + (length + '\u0001'));
            return;
        }
        int newend = start + length + 1;
        if (start == this.getValue(this.nbrruns - 1)) {
            if (newend < oldend) {
                this.setValue(this.nbrruns - 1, (char)newend);
                this.setLength(this.nbrruns - 1, (char)(oldend - newend - 1));
                return;
            }
            if (newend > oldend) {
                this.setValue(this.nbrruns - 1, (char)oldend);
                this.setLength(this.nbrruns - 1, (char)(newend - oldend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (char)(start - this.getValue(this.nbrruns - 1) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (char)newend);
            this.setLength(this.nbrruns, (char)(oldend - newend - 1));
            ++this.nbrruns;
        } else if (newend > oldend) {
            this.setValue(this.nbrruns, (char)oldend);
            this.setLength(this.nbrruns, (char)(newend - oldend - 1));
            ++this.nbrruns;
        }
    }

    MappeableContainer toBitmapOrArrayContainer(int card) {
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content.put(answer.cardinality++, (char)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    private MappeableContainer toEfficientContainer() {
        int card;
        int sizeAsArrayContainer;
        int sizeAsBitmapContainer;
        int sizeAsRunContainer = MappeableRunContainer.serializedSizeInBytes(this.nbrruns);
        if (sizeAsRunContainer <= Math.min(sizeAsBitmapContainer = MappeableBitmapContainer.serializedSizeInBytes(0), sizeAsArrayContainer = MappeableArrayContainer.serializedSizeInBytes(card = this.getCardinality()))) {
            return this;
        }
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                if (BufferUtil.isBackedBySimpleArray(answer.content)) {
                    char[] ba = answer.content.array();
                    for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                        ba[answer.cardinality++] = (char)runValue;
                    }
                    continue;
                }
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content.put(answer.cardinality++, (char)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    public char[] toCharArray() {
        char[] answer = new char[2 * this.nbrruns];
        this.valueslength.rewind();
        this.valueslength.get(answer);
        return answer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[]".length() + "-123456789,".length() * this.nbrruns);
        for (int k = 0; k < this.nbrruns; ++k) {
            sb.append('[');
            sb.append((int)this.getValue(k));
            sb.append(',');
            sb.append(this.getValue(k) + this.getLength(k));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.valueslength.limit() == 2 * this.nbrruns) {
            return;
        }
        if (BufferUtil.isBackedBySimpleArray(this.valueslength)) {
            this.valueslength = CharBuffer.wrap(Arrays.copyOf(this.valueslength.array(), 2 * this.nbrruns));
        } else {
            CharBuffer co = CharBuffer.allocate(2 * this.nbrruns);
            char[] a = co.array();
            for (int k = 0; k < 2 * this.nbrruns; ++k) {
                a[k] = this.valueslength.get(k);
            }
            this.valueslength = co;
        }
    }

    private boolean valueLengthContains(int value, int index) {
        char length;
        char initialValue = this.getValue(index);
        return value <= initialValue + (length = this.getLength(index));
    }

    @Override
    public void writeArray(ByteBuffer buffer, boolean isForBitmapSerialize) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        CharBuffer source = this.valueslength.duplicate();
        source.position(0);
        source.limit(this.nbrruns * 2);
        CharBuffer target = buffer.asCharBuffer();
        target.put((char)this.nbrruns);
        target.put(source);
        int bytesWritten = (this.nbrruns * 2 + 1) * 2;
        buffer.position(buffer.position() + bytesWritten);
    }

    @Override
    public void forEach(char msb, IntConsumer ic) {
        int high = msb << 16;
        for (int k = 0; k < this.nbrruns; ++k) {
            int base = this.getValue(k) & 0xFFFF | high;
            int le = this.getLength(k) & 0xFFFF;
            int l = base;
            while (l - le <= base) {
                ic.accept(l);
                ++l;
            }
        }
    }

    @Override
    public int andCardinality(MappeableArrayContainer x) {
        if (this.nbrruns == 0) {
            return 0;
        }
        int rlepos = 0;
        int arraypos = 0;
        int andCardinality = 0;
        char rleval = this.getValue(rlepos);
        char rlelength = this.getLength(rlepos);
        while (arraypos < x.cardinality) {
            char arrayval = x.content.get(arraypos);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return andCardinality;
                }
                rleval = this.getValue(rlepos);
                rlelength = this.getLength(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = BufferUtil.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            ++andCardinality;
            ++arraypos;
        }
        return andCardinality;
    }

    @Override
    public int andCardinality(MappeableBitmapContainer x) {
        int cardinality = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char runStart = this.getValue(rlepos);
            int runEnd = runStart + this.getLength(rlepos);
            cardinality += x.cardinalityInRange(runStart, runEnd + 1);
        }
        return cardinality;
    }

    @Override
    public int andCardinality(MappeableRunContainer x) {
        int cardinality = 0;
        int rlepos = 0;
        int xrlepos = 0;
        char start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            int lateststart = Math.max(start, xstart);
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            }
            cardinality += earliestend - lateststart;
        }
        return cardinality;
    }

    @Override
    public MappeableBitmapContainer toBitmapContainer() {
        int card = this.getCardinality();
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        for (int i = 0; i < this.numberOfRuns(); ++i) {
            char runFirstValue = this.getValue(i);
            char runLastValue = (char)(runFirstValue + this.getLength(i));
            if (runFirstValue >= supremum || runLastValue - (char)minimum < 0) continue;
            return true;
        }
        return false;
    }
}

