/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.validation;

import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.contextual.OlapContextualErrorException;
import crazydev.iccube.contextual.OlapContextualErrorManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.validation.IOlapValidationEnabled;
import crazydev.iccube.validation.OlapValidatorContext;
import org.apache.log4j.Logger;

public abstract class OlapValidator<CONTEXT extends OlapValidatorContext, PARENT extends IOlapValidationEnabled, CHILD extends IOlapValidationEnabled> {
    public static final Logger LOGGER = OlapLoggers.BUILDER;

    public final void validate(CONTEXT context, PARENT parent, CHILD child) {
        Object errorManager = ((OlapValidatorContext)context).getErrorManager();
        ((OlapContextualErrorManager)errorManager).pushContext((IOlapContextual)child);
        try {
            this.doValidate(context, parent, child);
        }
        catch (OlapContextualErrorException ex) {
            LOGGER.warn((Object)"validation error-exception", (Throwable)((Object)ex));
            ((OlapContextualErrorManager)errorManager).addError((OlapContextualError)ex.getError());
            throw new RuntimeException("marker:validation-error-exception");
        }
        catch (RuntimeException ex) {
            ((OlapContextualErrorManager)errorManager).addException(ex);
            throw new RuntimeException("marker:validation-runtime-exception");
        }
        finally {
            ((OlapContextualErrorManager)errorManager).popContext();
        }
    }

    protected abstract void doValidate(CONTEXT var1, PARENT var2, CHILD var3);
}

