/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.tidytable.sql;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.OlapBuilderAbstractTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.tidytable.sql.SqlTidyTable;
import crazydev.iccube.tidytable.sql.SqlTidyTableColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SqlTidyTableHelper {
    private final int maxRowCount;
    private final List<SqlTidyTableColumn> tidyColumns = new ArrayList<SqlTidyTableColumn>();
    private boolean maxRowCountReached = false;
    private int rowCount = 0;

    public SqlTidyTableHelper(IOlapBuilderDataTableDef<?> table, @Nullable Integer maxRowCount) {
        this.maxRowCount = maxRowCount != null ? maxRowCount : Integer.MAX_VALUE;
        table.addListener(new OlapBuilderAbstractTableListener(this){
            final /* synthetic */ SqlTidyTableHelper this$0;
            {
                SqlTidyTableHelper sqlTidyTableHelper = this$0;
                Objects.requireNonNull(sqlTidyTableHelper);
                this.this$0 = sqlTidyTableHelper;
            }

            @Override
            public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow row) {
                return this.this$0.onNewRow(context, columns, row);
            }
        });
    }

    private boolean onNewRow(OlapBuilderContext context, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow row) {
        if (context.isCancelling()) {
            return false;
        }
        if (this.rowCount >= this.maxRowCount) {
            this.maxRowCountReached = true;
            return false;
        }
        ++this.rowCount;
        if (this.tidyColumns.isEmpty()) {
            for (IOlapBuilderDataColumnDef column : columns) {
                this.tidyColumns.add(new SqlTidyTableColumn(column.getName()));
            }
        }
        int size = columns.size();
        for (int idx = 0; idx < size; ++idx) {
            IOlapBuilderDataColumnDef column = columns.get(idx);
            OlapScalarEntity value = row.getJavaNativeDataValueAsScalarEntity(column);
            SqlTidyTableColumn tidyColumn = this.tidyColumns.get(idx);
            tidyColumn.addScalarEntity(value);
        }
        return true;
    }

    public SqlTidyTable toTidyTable() {
        for (SqlTidyTableColumn tidyColumn : this.tidyColumns) {
            tidyColumn.inferType();
            tidyColumn.compact();
            tidyColumn.freeze();
        }
        return SqlTidyTable.create(this.tidyColumns, this.rowCount, this.maxRowCount, this.maxRowCountReached);
    }
}

