/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.tenants;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdHtmlUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.tenants.OlapTenantDefinition;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTenantUtils {
    private static final Set<String> REPORTING_FILES = new HashSet<String>();
    private static final Set<String> DASHBOARDS_FILES;

    private OlapTenantUtils() {
    }

    public static String getDirectory(OlapTenantDefinition tenant) {
        String dir = tenant.getDirectory();
        if (CdStringUtils.isNullOrBlank((String)dir)) {
            dir = tenant.getName();
        }
        return dir;
    }

    public static File getHomeDirectory(OlapDirectoriesResolved directories, OlapTenant tenant) throws OlapDirectoriesResolvedNotSuperAdminException {
        directories.assertRoot();
        String dir = tenant.getDirectory();
        File tenants = directories.getMultiTenantDirectory();
        OlapFile file = OlapFileSystem.createFileSystem(directories.getVfs(), tenants).create(dir);
        return file.__getUnderlying();
    }

    public static File getHomeDirectory(OlapDirectoriesResolved directories, OlapTenantDefinition tenant) throws OlapDirectoriesResolvedNotSuperAdminException {
        directories.assertRoot();
        String dir = OlapTenantUtils.getDirectory(tenant);
        File tenants = directories.getMultiTenantDirectory();
        OlapFile file = OlapFileSystem.createFileSystem(directories.getVfs(), tenants).create(dir);
        return file.__getUnderlying();
    }

    public static File getHomeDirectoryForUX(OlapDirectoriesResolved directories, OlapTenantDefinition tenant) {
        String dir = OlapTenantUtils.getDirectory(tenant);
        File tenants = directories.getMultiTenantDirectory();
        return new File(tenants, dir);
    }

    @Nullable
    public static File fixReportingFile(File tmpDirectory, String tenantName, String name, InputStream file) throws IOException {
        String baseName = FilenameUtils.getName((String)name);
        if (!REPORTING_FILES.contains(baseName)) {
            return null;
        }
        return OlapTenantUtils.fixFileForTenant(tmpDirectory, tenantName, baseName, file);
    }

    private static File fixFileForTenant(File tmpDirectory, String tenantName, String name, InputStream in) throws IOException {
        File tmp = OlapTenantUtils.ensureUniqueness(new File(tmpDirectory, CdVFileSystem.toFileName((String)(tenantName + "_" + name))));
        tmp.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tmp);){
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] fixing REPORTING file error [" + name + "] : " + ex.getMessage()), (Throwable)ex);
            throw new IOException("[docs] fixing REPORTING file error [" + name + "]", ex);
        }
        Path path = tmp.toPath();
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset);
        content = content.replace("?v=", "?v=" + CdHtmlUtils.escapeAttribute((String)tenantName));
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
        return tmp;
    }

    private static File ensureUniqueness(File file) {
        File parent = file.getParentFile();
        String name = file.getName();
        File uniqueFile = file;
        int count = 1;
        while (uniqueFile.exists()) {
            uniqueFile = new File(parent, name + "_" + count);
            ++count;
        }
        return uniqueFile;
    }

    @Nullable
    public static InputStream fixDashboardsFile(String tenantName, String name, InputStream file) throws IOException {
        String baseName = FilenameUtils.getName((String)name);
        if (!DASHBOARDS_FILES.contains(baseName)) {
            return null;
        }
        return OlapTenantUtils.doFixDashboardsFile(tenantName, baseName, file);
    }

    private static InputStream doFixDashboardsFile(String tenantName, String name, InputStream in) throws IOException {
        String content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        content = "index.html".equals(name) ? content.replaceAll("app/main\\.js\\?", "app/main.js?" + OlapTenantUtils.encoreUrlParameter(tenantName) + "_") : content.replace("?t=", "?t=" + OlapTenantUtils.encoreUrlParameter(tenantName) + "_");
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    private static String encoreUrlParameter(String param) {
        try {
            URI uri = new URIBuilder().addParameter("t", param).build();
            String query = uri.getRawQuery();
            return query.substring(2);
        }
        catch (URISyntaxException ex) {
            OlapLoggers.GENERAL.warn((Object)("encoreUrlParameter [" + param + "] error"), (Throwable)ex);
            return param;
        }
    }

    static {
        REPORTING_FILES.add("ic3report.html");
        REPORTING_FILES.add("ic3report-dev.html");
        REPORTING_FILES.add("ic3bootstrap.js");
        REPORTING_FILES.add("ic3bootstrap-dev.js");
        DASHBOARDS_FILES = new HashSet<String>();
        DASHBOARDS_FILES.add("index.html");
        DASHBOARDS_FILES.add("main.js");
        DASHBOARDS_FILES.add("remoteEntry.js");
    }
}

