/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.tenants;

import crazydev.iccube.tenants.OlapTenantDefinition;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="tenants")
public class OlapTenantDefinitions {
    public static final String FILE_ENCODING = "UTF-8";
    public static final String FILE_EXTENSION = "icc-tenants";
    public static final String FILE_EXTENSION_X = ".icc-tenants";
    public static final String FILE_NAME = "icCubeTenants";
    public static final String FULL_FILE_NAME = "icCubeTenants.icc-tenants";
    @XmlAttribute(name="revisionNumber", required=true)
    private int revisionNumber;
    @XmlElement(name="tenant", required=false)
    @Nullable
    private List<OlapTenantDefinition> tenantDefinitions;

    public List<OlapTenantDefinition> getTenantDefinitions() {
        ArrayList<OlapTenantDefinition> sorted = new ArrayList<OlapTenantDefinition>();
        if (this.tenantDefinitions != null) {
            sorted.addAll(this.tenantDefinitions);
        }
        return sorted;
    }

    public List<String> getTenantNamesForUX() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.tenantDefinitions != null) {
            for (OlapTenantDefinition tenantDefinition : this.tenantDefinitions) {
                names.add(tenantDefinition.getName());
            }
        }
        return names;
    }

    public List<OlapTenantDefinition> getSortedTenantDefinitionsForUX() {
        ArrayList<OlapTenantDefinition> sorted = new ArrayList<OlapTenantDefinition>();
        if (this.tenantDefinitions != null) {
            sorted.addAll(this.tenantDefinitions);
        }
        sorted.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return sorted;
    }

    @Nullable
    public OlapTenantDefinition getTenantDefinitionByUUID(String uuid) {
        if (this.tenantDefinitions != null) {
            for (OlapTenantDefinition tenant : this.tenantDefinitions) {
                if (!uuid.equals(tenant.getUUID())) continue;
                return tenant;
            }
        }
        return null;
    }

    @Nullable
    public OlapTenantDefinition getTenantDefinitionByName(String name) {
        if (this.tenantDefinitions != null) {
            for (OlapTenantDefinition tenant : this.tenantDefinitions) {
                if (!name.equals(tenant.getName())) continue;
                return tenant;
            }
        }
        return null;
    }

    public void addTenantDefinition(OlapTenantDefinition tenant) {
        if (this.tenantDefinitions == null) {
            this.tenantDefinitions = new ArrayList<OlapTenantDefinition>();
        }
        this.tenantDefinitions.add(tenant);
    }

    public void replaceTenantDefinition(OlapTenantDefinition tenant) {
        if (this.tenantDefinitions == null) {
            this.tenantDefinitions = new ArrayList<OlapTenantDefinition>();
            this.tenantDefinitions.add(tenant);
            return;
        }
        int pos = -1;
        for (int ii = 0; ii < this.tenantDefinitions.size(); ++ii) {
            OlapTenantDefinition roleDefinition = this.tenantDefinitions.get(ii);
            String uuid = roleDefinition.getUUID();
            if (uuid == null || !uuid.equals(tenant.getUUID())) continue;
            pos = ii;
            break;
        }
        if (pos == -1) {
            this.tenantDefinitions.add(tenant);
        } else {
            this.tenantDefinitions.set(pos, tenant);
        }
    }

    @Nullable
    public OlapTenantDefinition deleteTenantByUUID(String uuid) {
        if (this.tenantDefinitions == null) {
            return null;
        }
        OlapTenantDefinition tenant = this.getTenantDefinitionByUUID(uuid);
        if (tenant != null && this.tenantDefinitions.remove(tenant)) {
            return tenant;
        }
        return null;
    }
}

