/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.runtime;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.runtime.OlapCiRuntime;
import crazydev.iccube.runtime.OlapIdeaRuntime;
import crazydev.iccube.runtime.OlapProductionRuntime;
import crazydev.iccube.runtime.OlapRuntime;
import java.io.File;

public abstract class OlapRuntimeFactory {
    public static final String IC_CUBE_INSTALL = "icCube.install";

    public static OlapRuntime create() {
        if (OlapRuntimeFactory.isProduction()) {
            return OlapRuntimeFactory.createForProduction();
        }
        return OlapRuntimeFactory.createForDevelopment();
    }

    public static OlapRuntime createForProduction() {
        String installPath = System.getProperty(IC_CUBE_INSTALL);
        if (installPath == null) {
            throw new RuntimeException("internal error : missing expected JAVA system property [icCube.install]");
        }
        File install = new File(installPath);
        if (!install.exists() || !install.isDirectory()) {
            throw new RuntimeException("Wrong icCube.install system property [" + installPath + "] [" + install.getAbsolutePath() + "]!");
        }
        return new OlapProductionRuntime(install);
    }

    private static boolean isProduction() {
        return System.getProperty(IC_CUBE_INSTALL) != null;
    }

    public static OlapRuntime createForDevelopment() {
        if (OlapRuntimeFactory.isIdea()) {
            return new OlapIdeaRuntime();
        }
        if (OlapRuntimeFactory.isCI()) {
            return new OlapCiRuntime();
        }
        throw new CdProgrammingException("internal error : unexpected testing environment");
    }

    private static boolean isIdea() {
        return !OlapRuntimeFactory.isProduction() && !OlapRuntimeFactory.isCI();
    }

    private static boolean isCI() {
        return CdSystemUtils.getBooleanProperty((String)"icCube.ci", (boolean)false);
    }
}

