/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.runtime;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.directories.impl.OlapCubesDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapRolesDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapTenantsDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapUsersDirectoryConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public abstract class OlapRuntime {
    public static final boolean ACTIVATE_HELP_NG = true;
    private final CdVFileSystem vfs = new CdVFileSystem();

    public static boolean isWindows() {
        String icCubeOS = System.getProperty("icCube.os.name");
        if (CdStringUtils.isNotNullAndNotBlank((String)icCubeOS)) {
            return icCubeOS.toLowerCase().contains("windows");
        }
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    public static boolean isRunningWithIntelliJ() {
        String[] parts;
        String classpath = System.getProperty("java.class.path");
        for (String part : parts = classpath.split(":")) {
            if (!part.endsWith("/out/production/resources")) continue;
            return true;
        }
        return false;
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    public boolean isProduction() {
        return false;
    }

    public boolean isIDEA() {
        return false;
    }

    public boolean isCI() {
        return false;
    }

    public boolean isForPing() {
        return true;
    }

    public String getCWD() {
        return Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    public File getOutDirectory() {
        String tmp = System.getProperty("java.io.tmpdir");
        File out = new File(tmp, "icCube-dev");
        if (!out.exists()) {
            if (!out.mkdir()) {
                throw new RuntimeException("internal error: could not set the out directory!");
            }
        } else if (!out.isDirectory()) {
            throw new RuntimeException("internal error: inconsistent out directory!");
        }
        return out;
    }

    @Nullable
    public abstract String getDataDirectory();

    public abstract File getInstallDirectory();

    public abstract File getInstallBinDirectory();

    public abstract File getInstallCubesDirectory();

    public abstract File getInstallMdxQueriesDirectory();

    public abstract File getInstallPluginsDirectory();

    public File getInstallWebDirectory() {
        return this.getInstallUxDirectory();
    }

    public abstract File getInstallUxDirectory();

    public abstract File getInstallHelpDirectory();

    public abstract boolean requiresLoginPage();

    @Nullable
    public File getDataFileSystemRoot(@Nullable File root) {
        return root;
    }

    public File getLogFileSystemRoot(File root) {
        return root;
    }

    public void setUpCubesDirectory(OlapDirectoriesConfiguration directories) {
        OlapCubesDirectoryConfiguration directory = directories.getCubesDirectory();
        OlapLoggers.SERVER.debug((Object)("[directory] setup cubes [" + directory.asFile().getAbsolutePath() + "][created:" + directory.wasCreated() + "]"));
        if (!directory.wasCreated()) {
            return;
        }
        File from = this.getInstallCubesDirectory();
        try {
            OlapLoggers.SERVER.info((Object)("[directory] /cubes directory setup using the content of [" + from.getAbsolutePath() + "]"));
            CdVFileSystemUtils.copyDirectory((File)from, (File)directory.asFile());
        }
        catch (IOException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /cubes directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]."), (Throwable)ignored);
        }
    }

    public void setUpRolesDirectory(OlapDirectoriesConfiguration directories) {
        OlapRolesDirectoryConfiguration directory = directories.getRolesDirectory();
        OlapLoggers.SERVER.debug((Object)("[directory] setup roles [" + directory.asFile().getAbsolutePath() + "][created:" + directory.wasCreated() + "]"));
        if (!directory.wasCreated()) {
            return;
        }
        File from = new File(this.getInstallBinDirectory(), "icCubeRoles.icc-roles");
        try {
            CdVFileSystem vfs = this.getVfs();
            OlapLoggers.SERVER.info((Object)("[directory] /roles directory setup using [" + from.getAbsolutePath() + "]"));
            File to = new File(directory.asFile(), "icCubeRoles.icc-roles");
            vfs.copyForDirectoryInitOnStartup(from, to);
        }
        catch (IOException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /roles directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]."), (Throwable)ignored);
        }
    }

    public void setUpUsersDirectory(OlapDirectoriesConfiguration directories) {
        OlapUsersDirectoryConfiguration directory = directories.getUsersDirectory();
        OlapLoggers.SERVER.debug((Object)("[directory] setup users [" + directory.asFile().getAbsolutePath() + "][created:" + directory.wasCreated() + "]"));
        if (!directory.wasCreated()) {
            return;
        }
        File from = new File(this.getInstallBinDirectory(), "icCubeUsers.icc-users");
        try {
            CdVFileSystem vfs = this.getVfs();
            OlapLoggers.SERVER.info((Object)("[directory] /users directory setup using [" + from.getAbsolutePath() + "]"));
            File to = new File(directory.asFile(), "icCubeUsers.icc-users");
            vfs.copyForDirectoryInitOnStartup(from, to);
        }
        catch (IOException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /users directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]"), (Throwable)ignored);
        }
    }

    public void setUpTenantsDirectory(OlapDirectoriesConfiguration directories) {
        OlapTenantsDirectoryConfiguration directory = directories.getTenantsDirectory();
        if (directory == null) {
            OlapLoggers.SERVER.debug((Object)"[directory] setup tenants [null]");
            return;
        }
        OlapLoggers.SERVER.debug((Object)("[directory] setup tenants [" + directory.asFile().getAbsolutePath() + "][created:" + directory.wasCreated() + "]"));
        if (!directory.wasCreated()) {
            return;
        }
        File from = new File(this.getInstallBinDirectory(), "icCubeTenants.icc-tenants");
        try {
            CdVFileSystem vfs = this.getVfs();
            OlapLoggers.SERVER.info((Object)("[directory] /tenants directory setup using [" + from.getAbsolutePath() + "]"));
            File to = new File(directory.asFile(), "icCubeTenants.icc-tenants");
            vfs.copyForDirectoryInitOnStartup(from, to);
        }
        catch (IOException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /tenants directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]"), (Throwable)ignored);
        }
    }

    public void setUpWebPubDirectory(File webPub) {
        try {
            String config = "icCube.json";
            File from = new File(this.getInstallBinDirectory(), "icCube.json");
            if (!from.exists()) {
                return;
            }
            OlapLoggers.SERVER.info((Object)("[directory] /webPub setup using [" + from.getAbsolutePath() + "]"));
            File to = new File(webPub, "icCube.json");
            if (!to.exists()) {
                this.vfs.copyForDirectoryInitOnStartup(from, to);
            }
        }
        catch (IOException | RuntimeException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /webPub webPub [" + webPub.getAbsolutePath() + "]"), (Throwable)ignored);
        }
    }

    public File getWebDashboardsKit() {
        return new File(this.getInstallDirectory(), "icCube-dashboards-docs.zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapRuntimeDashboardsVersion getWebDashboardsVersion() {
        File kit = this.getWebDashboardsKit();
        if (kit == null || !kit.isFile()) {
            return null;
        }
        ZipFile in = null;
        try {
            in = new ZipFile(kit);
            Enumeration<? extends ZipEntry> enumeration = in.entries();
            while (enumeration.hasMoreElements()) {
                OlapRuntimeDashboardsVersion version;
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.equals("app/index.html")) continue;
                InputStream ins = in.getInputStream(zipEntry);
                List lines = IOUtils.readLines((InputStream)ins, (Charset)StandardCharsets.UTF_8);
                OlapRuntimeDashboardsVersion olapRuntimeDashboardsVersion = version = OlapRuntimeDashboardsVersion.parse(lines);
                return olapRuntimeDashboardsVersion;
            }
            enumeration = null;
            return enumeration;
        }
        catch (IOException ex) {
            OlapLoggers.GENERAL.error((Object)"[runtime] could not retrieve the version of the Web Dashboards kit", (Throwable)ex);
            OlapRuntimeDashboardsVersion olapRuntimeDashboardsVersion = null;
            return olapRuntimeDashboardsVersion;
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((Closeable)in);
            }
        }
    }
}

