/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.runtime;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.runtime.OlapDevelopmentRuntime;
import java.io.File;

public class OlapIdeaRuntime
extends OlapDevelopmentRuntime {
    @Override
    public boolean isIDEA() {
        return true;
    }

    @Override
    public File getInstallDirectory() {
        String install = System.getProperty("icCube.dev.install");
        if (install != null) {
            File directory = new File(install);
            if (!directory.exists()) {
                throw new CdRuntimeException("Could not found install directory: [" + install + "] does not exist!");
            }
            return directory;
        }
        return new File(".");
    }

    @Override
    public File getInstallBinDirectory() {
        return CdVFileSystem.assertDirectory((String)"install-bin", (File)new File(this.getInstallDirectory(), "/etc/olap/bin"));
    }

    @Override
    public File getInstallCubesDirectory() {
        return CdVFileSystem.assertDirectory((String)"install-cubes", (File)new File(this.getInstallDirectory(), "/etc/olap/cubes"));
    }

    @Override
    public File getInstallMdxQueriesDirectory() {
        return CdVFileSystem.assertDirectory((String)"install-mdxQueries", (File)new File(this.getInstallDirectory(), "/etc/olap/mdxQueries"));
    }

    @Override
    public File getInstallPluginsDirectory() {
        return CdVFileSystem.assertDirectory((String)"install-plugins", (File)new File(this.getInstallDirectory(), ""));
    }

    @Override
    public File getInstallUxDirectory() {
        File build = new File(this.getInstallDirectory(), "../icCubeServerUI/dist");
        if (build.exists() && build.isDirectory()) {
            return build;
        }
        throw new RuntimeException("Missing icCubeServerUI directory!");
    }

    @Override
    public File getInstallHelpDirectory() {
        if (OlapIdeaRuntime.isDad()) {
            return new File(this.getInstallDirectory(), "/doc/pub");
        }
        if (OlapIdeaRuntime.isLinux()) {
            return new File("/home/mpo/icCube/src/ic3-help-ng");
        }
        return new File("C:\\Users\\mpo\\icCube\\svn\\co\\trunk\\icCube\\out\\icCube\\help\\mdx-local");
    }

    @Override
    public boolean requiresLoginPage() {
        return false;
    }

    @Override
    public File getWebDashboardsKit() {
        return new File("/home/mpo/icCube/src/icCubeDashboards/kit-v8.4.6.zip");
    }
}

