/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import crazydev.common.utils.CdStringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IcCubeTablePartitionRequestStatus {
    private final String partitionName;
    private final Date timestampStarted;
    private final List<Info> infos = new ArrayList<Info>();
    @Nullable
    private Date timestampReadingCompleted;
    @Nullable
    private Date timestampProcessingCompleted;

    public IcCubeTablePartitionRequestStatus(String partitionName, Date timestampStarted) {
        this.partitionName = partitionName;
        this.timestampStarted = timestampStarted;
        this.infos.add(new CreationInfo());
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public boolean isEmpty() {
        return this.infos.isEmpty();
    }

    public List<Info> getInfos() {
        return this.infos;
    }

    @Nullable
    public Info getLastInfo() {
        if (!this.infos.isEmpty()) {
            return this.infos.get(this.infos.size() - 1);
        }
        return null;
    }

    public boolean isOngoing() {
        return !this.isProcessingCompleted();
    }

    public boolean isReadingCompleted() {
        return this.timestampReadingCompleted != null;
    }

    public boolean isProcessingCompleted() {
        return this.timestampProcessingCompleted != null;
    }

    public void onReadProgress(Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        this.infos.add(new ProgressInfo(timestamp, readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize));
        if (this.infos.size() > 10) {
            this.infos.remove(0);
        }
    }

    public void onReadCompleted(Date timestamp, long rowCount) {
        this.timestampReadingCompleted = timestamp;
    }

    public void onProcessingCompleted(Date timestamp) {
        this.timestampProcessingCompleted = timestamp;
    }

    static class CreationInfo
    extends Info {
        final Date timestamp = new Date();

        CreationInfo() {
        }

        @Override
        String asString() {
            return "reading";
        }

        @Override
        String asString(SimpleDateFormat dateFormat) {
            return String.format("%s : start reading\n", dateFormat.format(this.timestamp));
        }
    }

    public static abstract class Info {
        abstract String asString();

        abstract String asString(SimpleDateFormat var1);
    }

    static class ProgressInfo
    extends Info {
        final Date timestamp;
        final long readRowCount;
        final int readRowCountPerSec;
        final int processingQueuedTaskCount;
        final long processingQueueTaskSize;

        ProgressInfo(Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
            this.timestamp = timestamp;
            this.readRowCount = readRowCount;
            this.readRowCountPerSec = readRowCountPerSec;
            this.processingQueuedTaskCount = processingQueuedTaskCount;
            this.processingQueueTaskSize = processingQueueTaskSize;
        }

        @Override
        String asString() {
            return String.format("%s rows [%s rows/sec][proc. queue: %d/%d]", CdStringUtils.formatNice((long)this.readRowCount), CdStringUtils.formatNice((long)this.readRowCountPerSec), this.processingQueuedTaskCount, this.processingQueueTaskSize);
        }

        @Override
        String asString(SimpleDateFormat dateFormat) {
            return String.format("%s : %s rows [ %s rows/sec ] [ proc. queue : %d / %d ]\n", dateFormat.format(this.timestamp), CdStringUtils.formatNice((long)this.readRowCount), CdStringUtils.formatNice((long)this.readRowCountPerSec), this.processingQueuedTaskCount, this.processingQueueTaskSize);
        }
    }
}

