/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.request;

import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeRequestReply {
    private final IcCubeRequest request;
    @Nullable
    private Exception exception;

    public IcCubeRequestReply(IcCubeRequest request) {
        this.request = request;
    }

    public String getRequestClientUUID() {
        return this.request.getClientUUID();
    }

    public abstract boolean isMdxOnError();

    public boolean hasErrors() {
        return this.getException() != null;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public abstract boolean hasResponse();

    public void onRequestUnexpectedException(IcCubeRequestStatusManager statusManager, Exception exception) {
        this.release();
        if (this.exception == null) {
            this.exception = exception;
        }
        statusManager.onRequestUnexpectedException(this.request, exception);
    }

    public void reportRequestSetupSchedulingException(IcCubeRequestStatusManager statusManager, Exception exception) {
        this.release();
        if (this.exception == null) {
            this.exception = exception;
        }
        statusManager.onRequestSetupSchedulingException(this.request, exception);
    }

    public void reportTaskException(IcCubeRequestStatusManager statusManager, Exception exception) {
        this.release();
        if (this.exception == null) {
            this.exception = exception;
        }
        statusManager.onRequestTaskException(this.request, exception);
    }

    public void release() {
    }
}

