/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.log;

import crazydev.iccube.common.IOlapContext;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.olap.executor.IOlapExecutor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.task.IcCubeTask;
import crazydev.iccube.version.OlapVersion;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapRequestTracker {
    private static final Logger LOGGER = OlapLoggers.REQUEST;
    private static final String VERSION = OlapVersion.get().toString();

    public static void onServletStarted(OlapRequestInfo requestInfo) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " servlet-started [ " + VERSION + " ]"));
        }
    }

    public static void onServletDone(OlapRequestInfo requestInfo) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " servlet-done"));
        }
    }

    public static void onInternalFired(OlapRequestInfo requestInfo) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo) && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " internal-fired"));
        }
    }

    public static void onInternalSubmitStarted(OlapRequestInfo requestInfo) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " internal-submit-started"));
        }
    }

    public static void onInternalSubmitDone(OlapRequestInfo requestInfo) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " internal-submit-done"));
        }
    }

    public static void onRequestProcessStarted(String sessionId, OlapRequestInfo requestInfo, String info) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " request-process-started [session:" + sessionId + "] " + info));
        }
    }

    public static void onRequestProcessDone(OlapRequestInfo requestInfo) {
        OlapRequestId requestId = requestInfo.getRequestId();
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " request-process-done"));
        }
    }

    public static void onBatchStarted(OlapRequestId requestId, OlapRequestId parentRequestId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " batch-started " + parentRequestId.getId()));
        }
    }

    public static void onBatchDone(OlapRequestId requestId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " batch-done"));
        }
    }

    public static void onLoadSchemaAcquireTokenStarted(OlapRequestInfo requestInfo, Semaphore activeLoadSchema, String schema) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            int permits = activeLoadSchema.availablePermits();
            int waiting = activeLoadSchema.getQueueLength();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " load-schema-acquire-token-started (" + permits + "/" + waiting + ") " + schema));
        }
    }

    public static void onLoadSchemaAcquireTokenDone(OlapRequestInfo requestInfo, Semaphore activeLoadSchema, String schema) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            int permits = activeLoadSchema.availablePermits();
            int waiting = activeLoadSchema.getQueueLength();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " load-schema-acquire-token-done (" + permits + "/" + waiting + ") " + schema));
        }
    }

    public static void onLoadSchemaReleaseTokenStarted(OlapRequestInfo requestInfo, Semaphore activeLoadSchema, String schema) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            int permits = activeLoadSchema.availablePermits();
            int waiting = activeLoadSchema.getQueueLength();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " load-schema-release-token-started (" + permits + "/" + waiting + ") " + schema));
        }
    }

    public static void onLoadSchemaReleaseTokenDone(OlapRequestInfo requestInfo, Semaphore activeLoadSchema, String schema) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            int permits = activeLoadSchema.availablePermits();
            int waiting = activeLoadSchema.getQueueLength();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " load-schema-release-token-done (" + permits + "/" + waiting + ") " + schema));
        }
    }

    public static void onSubmitTasksStarted(OlapRequestInfo requestInfo, IOlapExecutor executor, int taskCount) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            int qCount = executor.getQueuedTaskCount();
            int taCount = executor.getActiveThreadCount();
            int tmCount = executor.getMaxThreadCount();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " submit-tasks-started " + taskCount + " q:" + qCount + " t:" + taCount + "/" + tmCount));
        }
    }

    public static void onSubmitTasksDone(OlapRequestInfo requestInfo, IOlapExecutor executor) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            int qCount = executor.getQueuedTaskCount();
            int taCount = executor.getActiveThreadCount();
            int tmCount = executor.getMaxThreadCount();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " submit-tasks-done q:" + qCount + " t:" + taCount + "/" + tmCount));
        }
    }

    public static void onSubmitTaskStarted(OlapRequestInfo requestInfo, IcCubeTask task) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " submit-task-started " + task.getTaskUid()));
        }
    }

    public static void onSubmitTaskDone(OlapRequestInfo requestInfo, IcCubeTask task) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " submit-task-done " + task.getTaskUid()));
        }
    }

    public static void onExecuteTaskStart(OlapRequestInfo requestInfo, IcCubeTask task) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " execute-task-started " + task.getTaskUid() + " [LOCK:" + task.getLockInfo() + "]"));
        }
    }

    public static void onRequestWithTimeout(IOlapContext context, int timeoutS) {
        if (LOGGER.isDebugEnabled() && timeoutS != -1) {
            OlapRequestId requestId = context.getRequestId();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " with timeout : " + timeoutS));
        }
    }

    public static void onExecuteTaskDone(OlapRequestInfo requestInfo, IcCubeTask task) {
        if (LOGGER.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            OlapRequestId requestId = requestInfo.getRequestId();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " execute-task-done " + task.getTaskUid()));
        }
    }

    public static void onMdxRequestProfileSelected(IOlapContext context, OlapEngineMdxEvalProfile profile) {
        if (LOGGER.isDebugEnabled()) {
            OlapRequestId requestId = context.getRequestId();
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " with profile : " + profile.getName() + " -  materializedSetTupleCount:" + profile.getMaterializedSetTupleCount() + " tidyMaterializedAxisTupleCount:" + profile.getTidyMaterializedAxisTupleCount() + " internalTupleListCount:" + profile.getInternalTupleListCount() + " internalTupleListCountCJ:" + profile.getInternalTupleListCountCJ() + " tidyRowCount:" + profile.getTidyRowCount() + " tidyColumnCount:" + profile.getTidyColumnCount() + " tidyCellCount:" + profile.getTidyCellCount() + " tidyCellCountNE:" + profile.getTidyCellCountNE() + " cellCount:" + profile.getCellCount() + " timeoutS:" + profile.getTimeoutS() + " threadCount:" + profile.getCellThreadCount() + " queueSize:" + profile.getCellQueueSize() + " extraThreadCount:" + profile.getExtraThreadCount() + " extraQueueSize:" + profile.getExtraQueueSize() + " neCjIndexCacheLimit:" + profile.getNeCjIndexCacheLimit() + " neCjAsyncActivated:" + profile.isNeCjAsyncActivated() + " neCjParallelActivated:" + profile.isNeCjParallelActivated() + " neCjThreadCount:" + profile.getNeCjThreadCount() + " neCjMaxPreCalculated:" + profile.getNeCjMaxPreCalculated() + " neCjMaxPreCalculatedTuples:" + profile.getNeCjMaxPreCalculatedTuples()));
        }
    }

    public static void onMdxRequestCountAcquirePermitStarted(IOlapContext context, Semaphore activeMdxCount, @Nullable String profileName) {
        if (LOGGER.isDebugEnabled()) {
            OlapRequestId requestId = context.getRequestId();
            int permits = activeMdxCount.availablePermits();
            int waiting = activeMdxCount.getQueueLength();
            Object profile = profileName == null ? "[global]" : "[" + profileName + "]";
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " " + (String)profile + " mdx-acquire-permit-started (" + permits + "/" + waiting + ")"));
        }
    }

    public static void onMdxRequestCountAcquirePermitInterrupted(IOlapContext context, Semaphore activeMdxCount, @Nullable String profileName) {
        if (LOGGER.isDebugEnabled()) {
            OlapRequestId requestId = context.getRequestId();
            int permits = activeMdxCount.availablePermits();
            int waiting = activeMdxCount.getQueueLength();
            Object profile = profileName == null ? "[global]" : "[" + profileName + "]";
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " " + (String)profile + " mdx-acquire-permit-interrupted (" + permits + "/" + waiting + ")"));
        }
    }

    public static void onMdxRequestCountAcquirePermitDone(IOlapContext context, Semaphore activeMdxCount, @Nullable String profileName) {
        if (LOGGER.isDebugEnabled()) {
            OlapRequestId requestId = context.getRequestId();
            int permits = activeMdxCount.availablePermits();
            int waiting = activeMdxCount.getQueueLength();
            Object profile = profileName == null ? "[global]" : "[" + profileName + "]";
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " " + (String)profile + " mdx-acquire-permit-done (" + permits + "/" + waiting + ")"));
        }
    }

    public static void onMdxRequestCountReleasePermitStarted(IOlapContext context, Semaphore activeMdxCount, @Nullable String profileName) {
        if (LOGGER.isDebugEnabled()) {
            OlapRequestId requestId = context.getRequestId();
            int permits = activeMdxCount.availablePermits();
            int waiting = activeMdxCount.getQueueLength();
            Object profile = profileName == null ? "[global]" : "[" + profileName + "]";
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " " + (String)profile + " mdx-release-permit-started (" + permits + "/" + waiting + ")"));
        }
    }

    public static void onMdxRequestCountReleasePermitDone(IOlapContext context, Semaphore activeMdxCount, @Nullable String profileName) {
        if (LOGGER.isDebugEnabled()) {
            OlapRequestId requestId = context.getRequestId();
            int permits = activeMdxCount.availablePermits();
            int waiting = activeMdxCount.getQueueLength();
            Object profile = profileName == null ? "[global]" : "[" + profileName + "]";
            LOGGER.debug((Object)("[R] " + requestId.getRequestTypeName() + " " + requestId.getId() + " " + (String)profile + " mdx-release-permit-done (" + permits + "/" + waiting + ")"));
        }
    }
}

