/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.log;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.request.log.OlapRequestType;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public class OlapRequestId {
    private static final AtomicLong uid = new AtomicLong(1L);
    private static ThreadLocal<OlapRequestId> __threadRequestId = new ThreadLocal();
    private final OlapRequestType requestType;
    private final long requestId;
    private String clientUUID;

    private OlapRequestId(OlapRequestType requestType, long requestId) {
        this(requestType, requestId, UUID.randomUUID().toString());
    }

    private OlapRequestId(OlapRequestType requestType, long requestId, String clientUUID) {
        this.requestType = requestType;
        this.requestId = requestId;
        this.clientUUID = clientUUID;
    }

    public static OlapRequestId next(OlapRequestType requestType) {
        long value = uid.getAndIncrement();
        return new OlapRequestId(requestType, value);
    }

    public static OlapRequestId next(OlapRequestType requestType, String clientUUID) {
        long value = uid.getAndIncrement();
        return new OlapRequestId(requestType, value, clientUUID);
    }

    public static void setThreadRequestId(OlapRequestId id) {
        __threadRequestId.set(id);
    }

    public static OlapRequestId getThreadRequestId(@Nullable String clientUUID) {
        OlapRequestId id = __threadRequestId.get();
        if (id == null) {
            throw new RuntimeException("internal error: inconsistent request ID setup");
        }
        __threadRequestId.set(null);
        if (CdStringUtils.isNotNullAndNotBlank((String)clientUUID)) {
            id.clientUUID = clientUUID;
        }
        return id;
    }

    public OlapRequestType getRequestType() {
        return this.requestType;
    }

    public String getRequestTypeName() {
        return this.requestType.name();
    }

    public long getId() {
        return this.requestId;
    }

    public String getClientUUID() {
        return this.clientUUID;
    }

    public String toString() {
        return "" + this.requestId;
    }
}

