/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.view;

import crazydev.common.collection.CdIComparableList;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public interface IOlapReadOnlyDataRow {
    public IOlapDataTableDef getTableDef();

    public Comparable get(IOlapColumnDef var1);

    public Comparable get(String var1);

    default public Number checkNumber(String columnName, Object value) {
        return this.checkType(Number.class, columnName, value);
    }

    default public Integer getAsInteger(String columnName) {
        Comparable value = this.get(columnName);
        return value == null ? null : Integer.valueOf(this.checkNumber(columnName, value).intValue());
    }

    default public Boolean getAsBoolean(String columnName) {
        Comparable value = this.get(columnName);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        return (Boolean)this.throwException("Cast exception for column '" + columnName + "'. Expected Boolean type got " + value.getClass().getSimpleName());
    }

    default public Long getAsLong(String columnName) {
        Comparable value = this.get(columnName);
        return value == null ? null : Long.valueOf(this.checkNumber(columnName, value).longValue());
    }

    default public Double getAsDouble(String columnName) {
        Comparable value = this.get(columnName);
        return value == null ? null : Double.valueOf(this.checkNumber(columnName, value).doubleValue());
    }

    default public LocalDate getAsDate(String columnName) {
        Comparable value = this.get(columnName);
        return this.toLocalDate(value);
    }

    default public LocalDateTime getAsDateTime(String columnName) {
        Comparable value = this.get(columnName);
        return this.toLocalDateTime(columnName, value);
    }

    default public <T extends Comparable> CdIComparableList<T> getAsArray(String columnDef) {
        Comparable value = this.get(columnDef);
        return this.checkType(CdIComparableList.class, columnDef, (CdIComparableList)value);
    }

    default public String getAsString(String columnName) {
        Comparable value = this.get(columnName);
        return value == null ? null : value.toString();
    }

    default public Integer getAsInteger(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return value == null ? null : Integer.valueOf(this.checkNumber(columnDef.getName(), value).intValue());
    }

    default public Long getAsLong(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return value == null ? null : Long.valueOf(this.checkNumber(columnDef.getName(), value).longValue());
    }

    default public Double getAsDouble(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return value == null ? null : Double.valueOf(this.checkNumber(columnDef.getName(), value).doubleValue());
    }

    default public String getAsString(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return value == null ? null : value.toString();
    }

    default public LocalDate getAsDate(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return this.toLocalDate(value);
    }

    default public LocalDateTime getAsDateTime(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return this.toLocalDateTime(columnDef.getName(), value);
    }

    default public <T extends Comparable> CdIComparableList<T> getAsArray(IOlapColumnDef columnDef) {
        Comparable value = this.get(columnDef);
        return this.checkType(CdIComparableList.class, columnDef.getName(), (CdIComparableList)value);
    }

    default public Comparable toValue(IOlapColumnDef columnDef, Comparable value) {
        return columnDef.getType().toJavaNativeValue(columnDef.getName(), value);
    }

    default public LocalDate toLocalDate(Comparable value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        return new LocalDate((Object)value);
    }

    default public LocalDateTime toLocalDateTime(String columnName, Comparable value) {
        return this.checkType(LocalDateTime.class, columnName, (LocalDateTime)value);
    }

    default public Double mult(String col1, String col2) {
        return this.mult(this.getAsDouble(col1), this.getAsDouble(col2));
    }

    default public Double div(String col1, String col2) {
        return this.div(this.getAsDouble(col1), this.getAsDouble(col2));
    }

    default public Double plus(String col1, String col2) {
        return this.plus(this.getAsDouble(col1), this.getAsDouble(col2));
    }

    default public Double minus(String col1, String col2) {
        return this.minus(this.getAsDouble(col1), this.getAsDouble(col2));
    }

    default public Double div(Double v1, Double v2) {
        return v1 == null || v2 == null ? null : Double.valueOf(v1 / v2);
    }

    default public Double mult(Double v1, Double v2) {
        return v1 == null || v2 == null ? null : Double.valueOf(v1 * v2);
    }

    default public Double plus(Double v1, Double v2) {
        return v1 == null && v2 == null ? null : Double.valueOf(this.nullAsZero(v1) + this.nullAsZero(v2));
    }

    default public Double minus(Double v1, Double v2) {
        return v1 == null && v2 == null ? null : Double.valueOf(this.nullAsZero(v1) - this.nullAsZero(v2));
    }

    default public double nullAsZero(Double v1) {
        return v1 == null ? 0.0 : v1;
    }

    default public <T> T throwException(String mess) {
        IOlapDataTableDef tableDef = this.getTableDef();
        throw new RuntimeException(mess + " in view/table '" + (tableDef == null ? "<MISSING>" : tableDef.getName()) + "'");
    }

    default public <T> T checkType(Class<T> type, String columnName, Object value) {
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            return this.throwException("Cast exception for column '" + columnName + "'. Expected type " + type.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return (T)value;
    }
}

