/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.utils;

import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class ic3DateTime {
    public static LocalDate endOfWeek(LocalDate date) {
        return date.dayOfWeek().withMaximumValue();
    }

    public static LocalDate endOfMonth(LocalDate date) {
        return date.dayOfMonth().withMaximumValue();
    }

    public static LocalDate endOfQuarter(LocalDate date) {
        int monthOfYear = date.getMonthOfYear();
        return date.withMonthOfYear(ic3DateTime.getQuarter(monthOfYear) + 2).dayOfMonth().withMaximumValue();
    }

    public static LocalDate endOfYear(LocalDate date) {
        return date.dayOfYear().withMaximumValue();
    }

    public static LocalDate startOfWeek(LocalDate date) {
        return date.dayOfWeek().withMinimumValue();
    }

    public static LocalDate startOfMonth(LocalDate date) {
        return date.dayOfMonth().withMinimumValue();
    }

    public static LocalDate startOfQuarter(LocalDate date) {
        int monthOfYear = date.getMonthOfYear();
        return date.withMonthOfYear(ic3DateTime.getQuarter(monthOfYear)).dayOfMonth().withMinimumValue();
    }

    public static LocalDate startOfYear(LocalDate date) {
        return date.dayOfYear().withMinimumValue();
    }

    public static LocalDate nextDay(LocalDate date) {
        return date.plusDays(1);
    }

    public static LocalDate nextWeek(LocalDate date) {
        return date.plusWeeks(1);
    }

    public static LocalDate nextMonth(LocalDate date) {
        return date.plusMonths(1);
    }

    public static LocalDate nextQuarter(LocalDate date) {
        return date.plusMonths(3);
    }

    public static LocalDate nextYear(LocalDate date) {
        return date.plusYears(1);
    }

    public static LocalDate previousDay(LocalDate date) {
        return date.minusDays(1);
    }

    public static LocalDate previousWeek(LocalDate date) {
        return date.minusWeeks(1);
    }

    public static LocalDate previousMonth(LocalDate date) {
        return date.minusMonths(1);
    }

    public static LocalDate previousQuarter(LocalDate date) {
        return date.minusMonths(3);
    }

    public static LocalDate previousYear(LocalDate date) {
        return date.minusYears(1);
    }

    public static LocalDate firstDayOfWeekOfMonth(LocalDate date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfMonth(date, weekday, 0);
    }

    public static LocalDate lastDayOfWeekOfMonth(LocalDate date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfMonth(date.plusMonths(1), weekday, -1);
    }

    public static LocalDate nhtDayOfWeekOfMonth(LocalDate date, int weekday, int nth) {
        return ic3DateTime.nhtDayOfWeekOfPeriod(ic3DateTime.startOfMonth(date), weekday, nth);
    }

    public static LocalDate firstDayOfWeekOfQuarter(LocalDate date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfQuarter(date, weekday, 0);
    }

    public static LocalDate lastDayOfWeekOfQuarter(LocalDate date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfQuarter(date.plusMonths(3), weekday, -1);
    }

    public static LocalDate nhtDayOfWeekOfQuarter(LocalDate date, int weekday, int nth) {
        return ic3DateTime.nhtDayOfWeekOfPeriod(ic3DateTime.startOfQuarter(date), weekday, nth);
    }

    public static LocalDate firstDayOfWeekOfYear(LocalDate date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfYear(date, weekday, 0);
    }

    public static LocalDate lastDayOfWeekOfYear(LocalDate date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfYear(date.plusYears(1), weekday, -1);
    }

    public static LocalDate nhtDayOfWeekOfYear(LocalDate date, int weekday, int nth) {
        return ic3DateTime.nhtDayOfWeekOfPeriod(ic3DateTime.startOfYear(date), weekday, nth);
    }

    private static LocalDate nhtDayOfWeekOfPeriod(LocalDate startPeriod, int weekday, int nth) {
        if (startPeriod.getDayOfWeek() > weekday) {
            startPeriod = startPeriod.plusWeeks(1);
        }
        return startPeriod.withDayOfWeek(weekday).plusWeeks(nth);
    }

    public static LocalDateTime endOfWeek(LocalDateTime date) {
        return date.dayOfWeek().withMaximumValue();
    }

    public static LocalDateTime endOfMonth(LocalDateTime date) {
        return date.dayOfMonth().withMaximumValue();
    }

    public static LocalDateTime endOfQuarter(LocalDateTime date) {
        int monthOfYear = date.getMonthOfYear();
        return date.withMonthOfYear(ic3DateTime.getQuarter(monthOfYear) + 2).dayOfMonth().withMaximumValue();
    }

    public static LocalDateTime endOfYear(LocalDateTime date) {
        return date.dayOfYear().withMaximumValue();
    }

    public static LocalDateTime startOfWeek(LocalDateTime date) {
        return date.dayOfWeek().withMinimumValue();
    }

    public static LocalDateTime startOfMonth(LocalDateTime date) {
        return date.dayOfMonth().withMinimumValue();
    }

    public static LocalDateTime startOfQuarter(LocalDateTime date) {
        int monthOfYear = date.getMonthOfYear();
        return date.withMonthOfYear(ic3DateTime.getQuarter(monthOfYear)).dayOfMonth().withMinimumValue();
    }

    public static LocalDateTime startOfYear(LocalDateTime date) {
        return date.dayOfYear().withMinimumValue();
    }

    public static LocalDateTime nextDay(LocalDateTime date) {
        return date.plusDays(1);
    }

    public static LocalDateTime nextWeek(LocalDateTime date) {
        return date.plusWeeks(1);
    }

    public static LocalDateTime nextMonth(LocalDateTime date) {
        return date.plusMonths(1);
    }

    public static LocalDateTime nextQuarter(LocalDateTime date) {
        return date.plusMonths(3);
    }

    public static LocalDateTime nextYear(LocalDateTime date) {
        return date.plusYears(1);
    }

    public static LocalDateTime previousDay(LocalDateTime date) {
        return date.minusDays(1);
    }

    public static LocalDateTime previousWeek(LocalDateTime date) {
        return date.minusWeeks(1);
    }

    public static LocalDateTime previousMonth(LocalDateTime date) {
        return date.minusMonths(1);
    }

    public static LocalDateTime previousQuarter(LocalDateTime date) {
        return date.minusMonths(3);
    }

    public static LocalDateTime previousYear(LocalDateTime date) {
        return date.minusYears(1);
    }

    public static LocalDateTime firstDayOfWeekOfMonth(LocalDateTime date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfMonth(date, weekday, 0);
    }

    public static LocalDateTime lastDayOfWeekOfMonth(LocalDateTime date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfMonth(date.plusMonths(1), weekday, -1);
    }

    public static LocalDateTime nhtDayOfWeekOfMonth(LocalDateTime date, int weekday, int nth) {
        return ic3DateTime.nhtDayOfWeekOfPeriod(ic3DateTime.startOfMonth(date), weekday, nth);
    }

    public static LocalDateTime firstDayOfWeekOfQuarter(LocalDateTime date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfQuarter(date, weekday, 0);
    }

    public static LocalDateTime lastDayOfWeekOfQuarter(LocalDateTime date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfQuarter(date.plusMonths(3), weekday, -1);
    }

    public static LocalDateTime nhtDayOfWeekOfQuarter(LocalDateTime date, int weekday, int nth) {
        return ic3DateTime.nhtDayOfWeekOfPeriod(ic3DateTime.startOfQuarter(date), weekday, nth);
    }

    public static LocalDateTime firstDayOfWeekOfYear(LocalDateTime date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfYear(date, weekday, 0);
    }

    public static LocalDateTime lastDayOfWeekOfYear(LocalDateTime date, int weekday) {
        return ic3DateTime.nhtDayOfWeekOfYear(date.plusYears(1), weekday, -1);
    }

    public static LocalDateTime nhtDayOfWeekOfYear(LocalDateTime date, int weekday, int nth) {
        return ic3DateTime.nhtDayOfWeekOfPeriod(ic3DateTime.startOfYear(date), weekday, nth);
    }

    private static LocalDateTime nhtDayOfWeekOfPeriod(LocalDateTime startPeriod, int weekday, int nth) {
        if (startPeriod.getDayOfWeek() > weekday) {
            startPeriod = startPeriod.plusWeeks(1);
        }
        return startPeriod.withDayOfWeek(weekday).plusWeeks(nth);
    }

    public static int getQuarter(LocalDate date) {
        return ic3DateTime.getQuarter(date.getMonthOfYear());
    }

    public static int getQuarter(LocalDateTime date) {
        return ic3DateTime.getQuarter(date.getMonthOfYear());
    }

    private static int getQuarter(int monthOfYear) {
        return 1 + 3 * ((monthOfYear - 1) / 3);
    }
}

