/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.role;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.pub.role.OlapOnTheFlyRoleDescriptionException;
import crazydev.iccube.pub.role.OlapOnTheFlyRoleNameFactory;
import crazydev.iccube.pub.role.OlapSimpleOnTheFlyRoleDefinitionBuilder;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class OlapSimpleOnTheFlyRoleDescription
implements IOlapOnTheFlyRoleDescription<OlapSimpleOnTheFlyRoleDescription> {
    private static final long serialVersionUID = 1871473473174333345L;
    private static OlapOnTheFlyRoleNameFactory roleNameFactory = OlapOnTheFlyRoleNameFactory.INSTANCE;
    private final String templateRoleName;
    private final String roleName;
    private final String roleNameForMdxExecutionProfile;
    private final String roleNameForDocs;
    private final String[] schemaNames;
    @Nullable
    private final String dimensionName;
    @Nullable
    private final String hierarchyName;
    @Nullable
    private final String[] members;
    @Nullable
    private final String dashboards;
    @Nullable
    private final String docs;

    protected OlapSimpleOnTheFlyRoleDescription(@Nullable String tenant, String userName, String templateRoleName, String roleNameForMdxExecutionProfile, String roleNameForDocs, String[] schemaNames, @Nullable String dimensionName, @Nullable String hierarchyName, @Nullable String[] members, @Nullable String dashboards, @Nullable String docs) throws OlapOnTheFlyRoleDescriptionException {
        if (templateRoleName == null) {
            throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected missing role template");
        }
        if (schemaNames == null || schemaNames.length == 0) {
            throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected missing schema");
        }
        for (String schemaName : schemaNames) {
            if (!CdStringUtils.isNullOrBlank((String)schemaName)) continue;
            throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected missing/empty schema");
        }
        if (dimensionName != null) {
            if (hierarchyName == null) {
                throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected missing hierarchy");
            }
            if (members == null || members.length == 0) {
                throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected missing member(s)");
            }
            this.templateRoleName = templateRoleName;
            this.roleName = roleNameFactory.getOrCreateUniqueRoleName(tenant, this, OlapSimpleOnTheFlyRoleDescription.createFullRoleName(templateRoleName, schemaNames, dimensionName, hierarchyName, members, dashboards, docs));
            this.schemaNames = schemaNames;
            this.dimensionName = dimensionName;
            this.hierarchyName = hierarchyName;
            this.members = members;
        } else {
            if (hierarchyName != null) {
                throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected hierarchy with no dimension");
            }
            if (members != null && members.length > 0) {
                throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected member(s) with no dimension");
            }
            this.templateRoleName = templateRoleName;
            this.roleName = roleNameFactory.getOrCreateUniqueRoleName(tenant, this, OlapSimpleOnTheFlyRoleDescription.createFullRoleName(templateRoleName, schemaNames, null, null, null, dashboards, docs));
            this.schemaNames = schemaNames;
            this.dimensionName = null;
            this.hierarchyName = null;
            this.members = null;
        }
        for (int ii = 0; ii < this.schemaNames.length; ++ii) {
            this.schemaNames[ii] = this.schemaNames[ii].trim();
        }
        this.roleNameForMdxExecutionProfile = roleNameForMdxExecutionProfile;
        this.roleNameForDocs = roleNameForDocs;
        this.dashboards = dashboards;
        this.docs = docs;
    }

    public static OlapSimpleOnTheFlyRoleDescription createForSchema(@Nullable String tenant, String userName, String templateRoleName, String roleNameForMdxExecutionProfile, String roleNameForDocs, String[] schemaNames, @Nullable String dashboards, @Nullable String docs) throws OlapOnTheFlyRoleDescriptionException {
        return new OlapSimpleOnTheFlyRoleDescription(tenant, userName, templateRoleName, roleNameForMdxExecutionProfile, roleNameForDocs, schemaNames, null, null, null, dashboards, docs);
    }

    public static OlapSimpleOnTheFlyRoleDescription createForMembers(@Nullable String tenant, String userName, String templateRoleName, String roleNameForMdxExecutionProfile, String roleNameForDocs, String schemaName, String dimensionName, String hierarchyName, String[] members, @Nullable String dashboards, @Nullable String docs) throws OlapOnTheFlyRoleDescriptionException {
        return new OlapSimpleOnTheFlyRoleDescription(tenant, userName, templateRoleName, roleNameForMdxExecutionProfile, roleNameForDocs, new String[]{schemaName}, dimensionName, hierarchyName, members, dashboards, docs);
    }

    public static OlapSimpleOnTheFlyRoleDescription createForMembers(@Nullable String tenant, String userName, String templateRoleName, String roleNameForMdxExecutionProfile, String roleNameForDocs, String[] schemaNames, String dimensionName, String hierarchyName, String[] members, @Nullable String dashboards, @Nullable String docs) throws OlapOnTheFlyRoleDescriptionException {
        return new OlapSimpleOnTheFlyRoleDescription(tenant, userName, templateRoleName, roleNameForMdxExecutionProfile, roleNameForDocs, schemaNames, dimensionName, hierarchyName, members, dashboards, docs);
    }

    private static String createFullRoleName(String templateRoleName, String[] schemaNames, @Nullable String dimensionName, @Nullable String hierarchyName, @Nullable String[] members, @Nullable String dashboards, @Nullable String docs) {
        StringBuilder sb = new StringBuilder();
        sb.append(templateRoleName);
        String[] sortedSchemaNames = new String[schemaNames.length];
        System.arraycopy(schemaNames, 0, sortedSchemaNames, 0, schemaNames.length);
        for (String sortedSchemaName : sortedSchemaNames) {
            sb.append("-").append(sortedSchemaName);
        }
        if (dimensionName != null) {
            sb.append("-").append(dimensionName.toLowerCase());
        }
        if (hierarchyName != null) {
            sb.append("-").append(hierarchyName.toLowerCase());
        }
        if (members != null) {
            Object[] sortedMembers = new String[members.length];
            System.arraycopy(members, 0, sortedMembers, 0, members.length);
            Arrays.sort(sortedMembers);
            for (Object sortedMember : sortedMembers) {
                sb.append("-").append((String)sortedMember);
            }
        }
        if (dashboards != null) {
            sb.append("-").append(dashboards);
        }
        if (docs != null) {
            sb.append("-").append(docs);
        }
        String fullRoleName = sb.toString();
        return fullRoleName;
    }

    @Override
    public String getNameSpace() {
        return "$OFT$";
    }

    @Override
    public String getTemplateRoleName() {
        return this.templateRoleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public String getRoleNameForMdxExecutionProfile() {
        return this.roleNameForMdxExecutionProfile;
    }

    @Override
    public String getRoleNameForDocs() {
        return this.roleNameForDocs;
    }

    public String[] getSchemaNames() {
        return this.schemaNames;
    }

    @Nullable
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Nullable
    public String getHierarchyName() {
        return this.hierarchyName;
    }

    @Nullable
    public String[] getMembers() {
        return this.members;
    }

    @Nullable
    public String getDashboards() {
        return this.dashboards;
    }

    @Nullable
    public String getDocs() {
        return this.docs;
    }

    public OlapSimpleOnTheFlyRoleDefinitionBuilder createBuilder() {
        return new OlapSimpleOnTheFlyRoleDefinitionBuilder();
    }

    public boolean equals(Object o) {
        throw new RuntimeException("internal error : inconsistent OlapOnTheFlyRoleDescription.equals usage");
    }

    public int hashCode() {
        throw new RuntimeException("internal error : inconsistent OlapOnTheFlyRoleDescription.equals usage");
    }
}

