/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.role;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleAccessDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeEntityListDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRolePerspectiveEntityListDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionEntityListDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyEntityListDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDefinitionBuilder;
import crazydev.iccube.pub.role.OlapSimpleOnTheFlyRoleDescription;

public class OlapSimpleOnTheFlyRoleDefinitionBuilder
implements IOlapOnTheFlyRoleDefinitionBuilder<OlapSimpleOnTheFlyRoleDescription> {
    @Override
    public OlapRoleDefinition createRoleDefinition(OlapSimpleOnTheFlyRoleDescription onTheFlyRoleDescription, OlapPrincipal principal, OlapRoleDefinition template) {
        String existingRoleName;
        String templateRoleName = onTheFlyRoleDescription.getTemplateRoleName();
        if (!templateRoleName.equals(existingRoleName = template.getName())) {
            throw new RuntimeException("internal error : inconsistent on-the-fly template role name [" + templateRoleName + "][" + existingRoleName + "]");
        }
        String roleName = onTheFlyRoleDescription.getRoleName();
        OlapRoleDefinition role = new OlapRoleDefinition(roleName, false);
        OlapRoleApplicationsDefinition applications = template.isFullControl() ? new OlapRoleApplicationsDefinition(OlapRoleApplicationsDefinition.createAllPermissionsAsEnabled()) : template.getValidatedApplicationsPermissions().copy();
        role.setApplicationsPermissions(applications);
        OlapRoleSchemasDefinition schemas = new OlapRoleSchemasDefinition();
        String[] schemaNames = onTheFlyRoleDescription.getSchemaNames();
        schemas.setDefaultSchemaAccess(OlapRoleAccessDefinition.READ);
        schemas.setAuthorizedSchemaNames(new OlapRoleSchemaEntityListDefinition(OlapRoleEntityListTypeDefinition.SELECTION, schemaNames));
        if (!principal.isAdministrator()) {
            for (String schemaName : schemaNames) {
                schemas.addSchemaPermission(OlapSimpleOnTheFlyRoleDefinitionBuilder.createSchemaDefinition(onTheFlyRoleDescription, schemaName));
            }
        }
        role.setSchemasPermissions(schemas);
        String dashboards = onTheFlyRoleDescription.getDashboards();
        String docs = onTheFlyRoleDescription.getDocs();
        role.setDashboardsPermissions(dashboards);
        role.setDocsPermissions(docs);
        return role;
    }

    private static OlapRoleSchemaDefinition createSchemaDefinition(OlapSimpleOnTheFlyRoleDescription onTheFlyRoleDescription, String schemaName) {
        OlapRoleSchemaDefinition schema = new OlapRoleSchemaDefinition(schemaName, OlapRoleAccessDefinition.READ);
        schema.setAuthorizedPerspectiveNames(new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]));
        schema.setAuthorizedCubeNames(new OlapRoleCubeEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]));
        schema.setAuthorizedDimensionNames(new OlapRoleDimensionEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]));
        String dimensionName = onTheFlyRoleDescription.getDimensionName();
        if (dimensionName != null) {
            OlapRoleDimensionDefinition dimension = new OlapRoleDimensionDefinition(OlapSimpleOnTheFlyRoleDefinitionBuilder.escapeMdxIdentifier(dimensionName));
            dimension.setAuthorizedHierarchyNames(new OlapRoleHierarchyEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]));
            String hierarchyName = onTheFlyRoleDescription.getHierarchyName();
            if (hierarchyName == null) {
                throw new RuntimeException("internal error : unexpected missing hierarchy [" + onTheFlyRoleDescription.getRoleName() + "]");
            }
            OlapRoleHierarchyDefinition hierarchy = new OlapRoleHierarchyDefinition(OlapSimpleOnTheFlyRoleDefinitionBuilder.escapeMdxIdentifier(hierarchyName));
            hierarchy.setAuthorizedMemberNamesType(OlapRoleEntityListTypeDefinition.SELECTION);
            String[] members = onTheFlyRoleDescription.getMembers();
            if (members == null || members.length == 0) {
                throw new RuntimeException("internal error : unexpected missing member(s) [" + onTheFlyRoleDescription.getRoleName() + "]");
            }
            hierarchy.setAuthorizedMemberNames(OlapSimpleOnTheFlyRoleDefinitionBuilder.createMembersSelection(dimensionName, hierarchyName, members));
            hierarchy.setApplyToCells(true);
            dimension.addHierarchyPermission(hierarchy);
            schema.addDimensionPermission(dimension);
        }
        return schema;
    }

    private static String escapeMdxIdentifier(String name) {
        return CdMdxUtils.escape((String)name);
    }

    private static String createDelimitedMdxIdentifier(String name) {
        return "[" + OlapSimpleOnTheFlyRoleDefinitionBuilder.escapeMdxIdentifier(name) + "]";
    }

    private static String createKeyMdxIdentifier(String name) {
        return "&[" + OlapSimpleOnTheFlyRoleDefinitionBuilder.escapeMdxIdentifier(name) + "]";
    }

    private static String createMembersSelection(String dimension, String hierarchy, String[] members) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String prefix = OlapSimpleOnTheFlyRoleDefinitionBuilder.createDelimitedMdxIdentifier(dimension) + "." + OlapSimpleOnTheFlyRoleDefinitionBuilder.createDelimitedMdxIdentifier(hierarchy) + ".";
        for (int idx = 0; idx < members.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(prefix).append(OlapSimpleOnTheFlyRoleDefinitionBuilder.createKeyMdxIdentifier(members[idx]));
        }
        sb.append("}");
        return sb.toString();
    }
}

