/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.principal;

import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.pub.utils.ic3CSRFUtils;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class OlapPrincipal
implements Serializable {
    public static final String SESSION_CONTEXT_KEY = "icCube.principal";
    private static final long serialVersionUID = -8396399774689195923L;
    private final String csrfToken;
    private final String name;
    @Nullable
    private final Locale locale;
    private final Map<String, Serializable> properties = new ConcurrentHashMap<String, Serializable>();
    @Nullable
    private OlapTenant tenant;
    private String authType;
    @Nullable
    private Map<String, String> authInfo;

    protected OlapPrincipal(String name, @Nullable Locale locale) {
        this(null, name, locale);
    }

    protected OlapPrincipal(@Nullable OlapTenant tenant, String name, @Nullable Locale locale) {
        this.csrfToken = ic3CSRFUtils.generate();
        this.tenant = tenant;
        this.name = name;
        this.locale = locale;
    }

    public boolean isAdministrator() {
        return "administrator".equals(this.getRoleName());
    }

    public boolean isAnonymous() {
        return "anonymous".equals(this.getRoleName());
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isOnTheFly() {
        return false;
    }

    public String getCSRFToken() {
        return this.csrfToken;
    }

    public boolean isPublicAsset() {
        return false;
    }

    @Nullable
    public Serializable setCustomProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    @Nullable
    public Serializable getCustomProperty(String name) {
        return this.properties.get(name);
    }

    @Nullable
    public OlapTenant getTenant() {
        return this.tenant;
    }

    public void resetTenant(@Nullable OlapTenant tenant) {
        this.tenant = tenant;
    }

    @Nullable
    public String getTenantName() {
        return this.tenant != null ? this.tenant.getName() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    public String getAuthType() {
        return this.authType != null ? this.authType : "";
    }

    public void setAuthType(String authType) {
        this.authType = authType != null ? authType : "";
    }

    public abstract String getTemplateRoleName();

    public abstract String getRoleName();

    public String getRoleNameForMdxExecutionProfile() {
        return this.getRoleName();
    }

    public String getRoleNameForDocs() {
        return this.getRoleName();
    }

    @Nullable
    public abstract String getRoleDescription();

    @Nullable
    public abstract IOlapOnTheFlyRoleDescription<?> getOnTheFlyRoleDescription();

    @Nullable
    public Map<String, String> getAuthInfo() {
        return this.authInfo;
    }

    public OlapPrincipal setAuthInfo(Map<String, String> authInfo) {
        this.authInfo = authInfo;
        return this;
    }

    public String logInfo() {
        return "[" + this.name + "][" + this.getRoleName() + "][" + System.identityHashCode(this) + "]";
    }

    public String toString() {
        return this.name + "/" + this.getRoleName();
    }
}

