/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.common;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class IOlapServiceConfiguration {
    public static final String TMP_DIRECTORY = "ic3tmpDirectory";
    public static final String USERS_DIRECTORY = "ic3usersDirectory";
    public static final String ROLE_DEFINITIONS = "ic3roleDefinitions";
    public static final String ROLE_PERMISSIONS = "ic3rolePermissions";
    public static final String OLAP_ENGINE_APP_CONTEXT = "olapEngineAppContext";

    public static IOlapServiceConfiguration empty() {
        return new IOlapServiceConfiguration(){

            @Override
            public List<String> getConfigurationProperties() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public Object getConfigurationProperty(String name) {
                return null;
            }
        };
    }

    public abstract List<String> getConfigurationProperties();

    @Nullable
    public abstract Object getConfigurationProperty(String var1);

    @Nullable
    public String getConfigurationStringProperty(String name) {
        Object property = this.getConfigurationProperty(name);
        if (property == null) {
            return null;
        }
        return property.toString();
    }

    public String getConfigurationStringProperty(String name, String defaultValue) {
        Object property = this.getConfigurationProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return property.toString();
    }

    public int getConfigurationIntProperty(String name, int defaultValue) throws OlapConfigurationException {
        Object property = this.getConfigurationProperty(name);
        if (property == null) {
            return defaultValue;
        }
        try {
            if (property instanceof String) {
                String s = (String)property;
                int res = Integer.parseInt(s);
                return res;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new OlapConfigurationException(OlapConfigurationErrorCode.PROPERTY_TYPE_ERROR, new Serializable[]{name, "integer", property.toString()});
    }

    public boolean getConfigurationBooleanProperty(String name, boolean defaultValue) throws OlapConfigurationException {
        Object property = this.getConfigurationProperty(name);
        if (property == null) {
            return defaultValue;
        }
        if (property instanceof Boolean) {
            boolean res = (Boolean)property;
            return res;
        }
        if (property instanceof String) {
            String s = (String)property;
            boolean res = Boolean.valueOf(s);
            return res;
        }
        throw new OlapConfigurationException(OlapConfigurationErrorCode.PROPERTY_TYPE_ERROR, new Serializable[]{name, "boolean", property.toString()});
    }
}

