/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.util;

import crazydev.iccube.olap.loggers.OlapLoggers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;

public class OlapOOM {
    public static volatile boolean oom = false;

    public static void reset() {
        if (oom) {
            OlapLoggers.SERVER.warn((Object)"[OOM] reset");
            oom = false;
        }
    }

    public static void setupUncaughtException() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            if (e instanceof OutOfMemoryError) {
                oom = true;
            }
            System.err.print("uncaught exception in thread [" + t.getName() + "] ");
            e.printStackTrace(System.err);
        });
    }

    public static void setupLog4J() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        AbstractAppender appender = new AbstractAppender("OOM", null, null, true, Property.EMPTY_ARRAY){

            public void append(LogEvent event) {
                Throwable err = event.getThrown();
                if (err instanceof OutOfMemoryError) {
                    oom = true;
                }
            }
        };
        appender.start();
        config.addAppender((Appender)appender);
        LoggerConfig root = config.getRootLogger();
        root.addAppender((Appender)appender, null, null);
        context.updateLoggers();
    }
}

